<?php

global $project;
$project = 'site';

global $database;
$database = '1400tower';

require_once('conf/ConfigureFromEnv.php');

i18n::set_locale('en_US');	// Set the site locale

// Use LeftAndMain.application_name
LeftAndMain::setApplicationName('K|H CMS');
//LeftAndMain::set_loading_image('themes/default/images/loading.gif');

// Use yml SSViewer.theme
//SSViewer::set_theme(''); 

if (Director::isLive()) {
	Director::forceSSL();
}

/* ======================================================================================
// Debugging & Logging
// log errors and warnings
-------------------------------------------- */

//SSViewer::set_source_file_comments(true);

/* PHP setting for reporting errors.
-------------------------------------- */
//ini_set('display_errors', 1);											

/* Write to log file.
-------------------------------------- */
SS_Log::add_writer(new SS_LogFileWriter(Director::baseFolder().'/assets/error_log.txt'), SS_Log::WARN, '<=');

/*  Email errors
------------------------------------ */
//SS_Log::add_writer(new SS_LogEmailWriter('micah@klundthosmer.com'), SS_Log::WARN, '<=');	


// ======================================================================================
// Email Settings
/*if( Director::isLive() )
	Email::bcc_all_emails_to("khdesign@klundthosmer.com");
else
	//Email::send_all_emails_to("micah@klundthosmer.com");
	Email::setAdminEmail( "khdesign@klundthosmer.com" );*/
	
/* HTML Editor config
--------------------------------------*/
HtmlEditorConfig::get('cms')->setButtonsForLine(1,
	'bold', 'italic','sup', 'sub', 'separator', 'justifyleft', 'justifycenter', 'justifyright', 'justifyfull', 'separator', 'removeformat', 'styleselect', 'formatselect', 'bullist', 'numlist', 'separator', 'outdent', 'indent','separator', 'blockquote',	'hr', 'charmap'
);
  
HtmlEditorConfig::get('cms')->setOption('theme_advanced_blockformats', 'p,h2,h3,h4,h5,h6');
HtmlEditorConfig::get('cms')->setOption('paste_text_sticky', true);
HtmlEditorConfig::get('cms')->setOption('paste_text_sticky_default', true);


// ======================================================================================
// Misc

//FulltextSearchable::enable();		// enable search box

// Custom CSS for the CMS interface.
//LeftAndMain::require_css('site/css/cms.css');

// SiteConfig_Decorator allows for adding configuration interface items to the Site Config portion of the CMS.
//DataObject::add_extension('SiteConfig', 'SiteConfig_Extension');


// ======================================================================================
// Blog Settings

// Form Spam protection
//RecaptchaField::$public_api_key = '6LfOQ8kSAAAAABIsFGZ6mLk517CerXlzsSlegPjx';
//RecaptchaField::$private_api_key = '6LfOQ8kSAAAAAD4XUrf5gOqyrMR_xHt-7kXEMC2_';
//RecaptchaField::$js_options = array('theme' => 'white');  // choices are red, white, clean and blackglass

// ==========================================================================================
// Place custom configuration for this site below this line

// ==========================================================================================
// MODULE VERSION LOG
//	Place comments about installed modules and customizations here.
