<?php
class BioPage extends Page {

	private static $db = array(
	);

	private static $has_one = array(
		"BioImage" => "Image"
	);

	// This function allows you to define custom fields in the CMS.
	function getCMSFields(){
		$fields = parent::getCMSFields();


		// The following lines add a field for uploading a single image and defines the folder where the image will be saved in /assets
		$fields->addFieldToTab("Root.Main", $page_image_field = UploadField::create("BioImage", "Select bio image (170px x 200px, 72dpi)."));
		$page_image_field->setFolderName("BioImages");

		// The following line is always required to acutally put the fields into the CMS.
		return $fields;
	}

}
class BioPage_Controller extends Page_Controller {

	private static $allowed_actions = array (
	);

	public function init() {
		parent::init();
		
		$themeDir = $this->ThemeDir();
		Requirements::set_combined_files_folder($themeDir . '/combinedfiles');
		Requirements::block(THIRDPARTY_DIR . "/jquery/jquery.js"); // block framework jquery, as we always want to use a newer version.
		
		$cssfiles = array(
			$themeDir . '/css/bootstrap.min.css',
			$themeDir . '/css/superfish.css',
			$themeDir . '/css/layout.css',
			$themeDir . '/css/form.css'
		);
		Requirements::combine_files("pagecss.css", $cssfiles);
		
		$jscripts = array(
			$themeDir . '/javascript/jquery-1.11.1.min.js',
			$themeDir . '/javascript/bootstrap.min.js',
			$themeDir . '/javascript/hoverIntent.js',
			$themeDir . '/javascript/superfish.min.js',
			$themeDir . '/javascript/script.js'
		);
		Requirements::combine_files('pagejs.js', $jscripts);

	}

	public function PageByID($id){
		return Page::get()->byID($id);
	}

}