<?php
class HomePage extends Page {

	private static $db = array(
		"VideoTitle" => "Varchar(45)",
		"VideoEmbedCode" => "HTMLText",
		"ContactName" => "Varchar(40)",
		"ContactJobTitle" => "Varchar(40)",
		"ContactEmail" => "Varchar(40)",
		"ContactPhone" => "Varchar(40)",
		"ContactInstructions" => "Varchar(128)",
	);

	private static $has_one = array(
		"CircleImage1" => "Image",
		"CircleImage2" => "Image",
		"CircleImage3" => "Image",
		"CircleImage4" => "Image",
		"ContactImage" => "Image",
	);

	function getCMSFields(){
		$fields = parent::getCMSFields();

		$fields->addFieldToTab("Root.Images", HeaderField::create("Upload 252px x 252px (72dpi) square images",2));
		$fields->addFieldToTab("Root.Images", $circle_image_1_field = UploadField::create("CircleImage1", "Add first circle image."));
		$circle_image_1_field->setFolderName("HomePageImages");

		$fields->addFieldToTab("Root.Images", $circle_image_2_field = UploadField::create("CircleImage2", "Add first circle image."));
		$circle_image_2_field->setFolderName("HomePageImages");

		$fields->addFieldToTab("Root.Images", $circle_image_3_field = UploadField::create("CircleImage3", "Add first circle image."));
		$circle_image_3_field->setFolderName("HomePageImages");

		$fields->addFieldToTab("Root.Images", $circle_image_4_field = UploadField::create("CircleImage4", "Add first circle image."));
		$circle_image_4_field->setFolderName("HomePageImages");

		$fields->addFieldToTab("Root.Video", TextField::create("VideoTitle", "Enter the video title."));
		$fields->addFieldToTab("Root.Video", TextAreaField::create("VideoEmbedCode", "Enter the video embed code (YouTube or Vimeo)."));

		$fields->addFieldToTab("Root.Contact", $contact_image = UploadField::create("ContactImage", "Select the contact image."));
		$contact_image->setFolderName("HomePageImages");
		$fields->addFieldToTab("Root.Contact", TextField::create("ContactName", "Enter contact person’s name."));
		$fields->addFieldToTab("Root.Contact", TextField::create("ContactJobTitle", "Enter contact person’s title."));
		$fields->addFieldToTab("Root.Contact", TextField::create("ContactEmail", "Enter contact person’s email address."));
		$fields->addFieldToTab("Root.Contact", TextField::create("ContactPhone", "Enter contact person’s phone number."));
		$fields->addFieldToTab("Root.Contact", TextAreaField::create("ContactInstructions", "Enter the contact section content."));


		return $fields;
	}

}
class HomePage_Controller extends Page_Controller {

	private static $allowed_actions = array (
	);

	public function init() {
		parent::init();
		$themeDir = $this->ThemeDir();

		$cssfiles = array(
			$themeDir . '/css/homepage.css'
		);
		Requirements::combine_files("homepagecss.css", $cssfiles);

		Requirements::javascript("https://player.vimeo.com/api/player.js");
	}
}