<?php

class PlaceHolderPage extends SiteTree {

	private static $description = 'Page for holding other pages but cannot be linked to.';

	private static $db = array(
		'RedirectFirstChild' => 'Boolean'
	);

	private static $defaults = array(
		'ShowInSearch' => 0
	);

	private static $icon = 'site/images/placemark.png';

	public function getCMSFields() {
		$fields = parent::getCMSFields();
		$fields->removeByName('Content');
		$fields->removeByName('Metadata');
		$fields->addFieldToTab('Root.Main', HeaderField::create('PageInfo', "ThisPage is used to hold other pages."));
		$fields->addFieldToTab('Root.Main', CheckboxField::create('NotLink', "Redirect to first child page."));
		return $fields;
	}

    /**
     * for use with legacy templates NotLink markup
     */
    public function NotLink() {
        return $this->RedirectFirstChild ? false : true;
    }

}

class PlaceHolderPage_Controller extends ContentController {

	public function index() {
		if( $this->current_stage() == "Stage" ) {return "";}
		if ($this->Children()->count() == 0) {
			$this->redirect('/');
		}
		else $this->redirect($this->Children()->first()->Link());
	}
}