-- MySQL dump 10.13  Distrib 5.7.31, for Linux (x86_64)
--
-- Host: localhost    Database: 1400tower
-- ------------------------------------------------------
-- Server version	5.7.31

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `1400tower`
--


--
-- Table structure for table `BioPage`
--

DROP TABLE IF EXISTS `BioPage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `BioPage` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `BioImageID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `BioImageID` (`BioImageID`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `BioPage`
--

LOCK TABLES `BioPage` WRITE;
/*!40000 ALTER TABLE `BioPage` DISABLE KEYS */;
INSERT INTO `BioPage` (`ID`, `BioImageID`) VALUES (7,10),(8,11),(9,12),(10,13),(11,14);
/*!40000 ALTER TABLE `BioPage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `BioPage_Live`
--

DROP TABLE IF EXISTS `BioPage_Live`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `BioPage_Live` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `BioImageID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `BioImageID` (`BioImageID`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `BioPage_Live`
--

LOCK TABLES `BioPage_Live` WRITE;
/*!40000 ALTER TABLE `BioPage_Live` DISABLE KEYS */;
INSERT INTO `BioPage_Live` (`ID`, `BioImageID`) VALUES (7,10),(8,11),(9,12),(10,13),(11,14);
/*!40000 ALTER TABLE `BioPage_Live` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `BioPage_versions`
--

DROP TABLE IF EXISTS `BioPage_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `BioPage_versions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RecordID` int(11) NOT NULL DEFAULT '0',
  `Version` int(11) NOT NULL DEFAULT '0',
  `BioImageID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `RecordID_Version` (`RecordID`,`Version`),
  KEY `RecordID` (`RecordID`),
  KEY `Version` (`Version`),
  KEY `BioImageID` (`BioImageID`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `BioPage_versions`
--

LOCK TABLES `BioPage_versions` WRITE;
/*!40000 ALTER TABLE `BioPage_versions` DISABLE KEYS */;
INSERT INTO `BioPage_versions` (`ID`, `RecordID`, `Version`, `BioImageID`) VALUES (1,7,6,0),(2,8,6,0),(3,9,5,0),(4,10,5,0),(5,11,5,0),(6,7,7,0),(7,8,7,0),(8,9,6,0),(9,10,6,0),(10,11,6,0),(11,7,8,0),(12,8,8,0),(13,9,7,0),(14,10,7,0),(15,11,7,0),(16,7,9,10),(17,8,9,11),(18,9,8,12),(19,10,8,13),(20,11,8,14),(21,8,10,11),(22,7,10,10),(23,8,11,11),(24,9,9,12),(25,10,9,13),(26,10,10,13),(27,17,3,0),(28,17,4,0),(29,17,5,0),(30,17,6,0),(31,17,7,0),(32,17,8,0);
/*!40000 ALTER TABLE `BioPage_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ErrorPage`
--

DROP TABLE IF EXISTS `ErrorPage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ErrorPage` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ErrorCode` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ErrorPage`
--

LOCK TABLES `ErrorPage` WRITE;
/*!40000 ALTER TABLE `ErrorPage` DISABLE KEYS */;
INSERT INTO `ErrorPage` (`ID`, `ErrorCode`) VALUES (4,404),(5,500);
/*!40000 ALTER TABLE `ErrorPage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ErrorPage_Live`
--

DROP TABLE IF EXISTS `ErrorPage_Live`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ErrorPage_Live` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ErrorCode` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ErrorPage_Live`
--

LOCK TABLES `ErrorPage_Live` WRITE;
/*!40000 ALTER TABLE `ErrorPage_Live` DISABLE KEYS */;
INSERT INTO `ErrorPage_Live` (`ID`, `ErrorCode`) VALUES (4,404),(5,500);
/*!40000 ALTER TABLE `ErrorPage_Live` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ErrorPage_versions`
--

DROP TABLE IF EXISTS `ErrorPage_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ErrorPage_versions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RecordID` int(11) NOT NULL DEFAULT '0',
  `Version` int(11) NOT NULL DEFAULT '0',
  `ErrorCode` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `RecordID_Version` (`RecordID`,`Version`),
  KEY `RecordID` (`RecordID`),
  KEY `Version` (`Version`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ErrorPage_versions`
--

LOCK TABLES `ErrorPage_versions` WRITE;
/*!40000 ALTER TABLE `ErrorPage_versions` DISABLE KEYS */;
INSERT INTO `ErrorPage_versions` (`ID`, `RecordID`, `Version`, `ErrorCode`) VALUES (1,4,1,404),(2,5,1,500);
/*!40000 ALTER TABLE `ErrorPage_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `File`
--

DROP TABLE IF EXISTS `File`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `File` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('File','Folder','Image','Image_Cached') DEFAULT 'File',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `Name` varchar(255) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `Filename` mediumtext,
  `Content` mediumtext,
  `ShowInSearch` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ParentID` int(11) NOT NULL DEFAULT '0',
  `OwnerID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `ParentID` (`ParentID`),
  KEY `OwnerID` (`OwnerID`),
  KEY `ClassName` (`ClassName`),
  FULLTEXT KEY `SearchFields` (`Title`,`Filename`,`Content`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `File`
--

LOCK TABLES `File` WRITE;
/*!40000 ALTER TABLE `File` DISABLE KEYS */;
INSERT INTO `File` (`ID`, `ClassName`, `LastEdited`, `Created`, `Name`, `Title`, `Filename`, `Content`, `ShowInSearch`, `ParentID`, `OwnerID`) VALUES (1,'Folder','2016-10-20 10:11:49','2016-10-20 10:11:49','HomePageImages','HomePageImages','assets/HomePageImages/',NULL,1,0,1),(5,'Image','2016-10-20 10:12:11','2016-10-20 10:12:11','winetoast.jpg','winetoast','assets/HomePageImages/winetoast.jpg',NULL,1,1,1),(4,'Image','2016-10-20 10:12:08','2016-10-20 10:12:08','monroestbridge.jpg','monroestbridge','assets/HomePageImages/monroestbridge.jpg',NULL,1,1,1),(6,'Image','2016-10-20 10:12:15','2016-10-20 10:12:15','clocktower.jpg','clocktower','assets/HomePageImages/clocktower.jpg',NULL,1,1,1),(7,'Image','2016-10-20 10:12:17','2016-10-20 10:12:17','spokaneclub.jpg','spokaneclub','assets/HomePageImages/spokaneclub.jpg',NULL,1,1,1),(8,'Image','2016-10-20 12:14:37','2016-10-20 12:14:37','shelley.png','shelley','assets/HomePageImages/shelley.png',NULL,1,1,1),(9,'Folder','2016-10-24 16:32:56','2016-10-24 16:32:56','BioImages','BioImages','assets/BioImages/',NULL,1,0,1),(10,'Image','2016-10-24 16:32:56','2016-10-24 16:32:56','mick.jpg','mick','assets/BioImages/mick.jpg',NULL,1,9,1),(11,'Image','2016-10-24 16:33:04','2016-10-24 16:33:04','shelley.jpg','shelley','assets/BioImages/shelley.jpg',NULL,1,9,1),(12,'Image','2016-10-24 16:33:11','2016-10-24 16:33:11','anton.jpg','anton','assets/BioImages/anton.jpg',NULL,1,9,1),(13,'Image','2016-10-24 16:33:16','2016-10-24 16:33:16','donald.jpg','donald','assets/BioImages/donald.jpg',NULL,1,9,1),(14,'Image','2016-10-24 16:33:23','2016-10-24 16:33:23','tobby.jpg','tobby','assets/BioImages/tobby.jpg',NULL,1,9,1),(15,'Image','2016-10-24 16:53:30','2016-10-24 16:53:30','monroestbridge.jpg','monroestbridge','assets/HomePageImages/monroestbridge.jpg',NULL,1,1,1),(16,'Image','2016-10-24 16:53:39','2016-10-24 16:53:39','winetoast.jpg','winetoast','assets/HomePageImages/winetoast.jpg',NULL,1,1,1),(17,'Image','2016-10-24 16:53:44','2016-10-24 16:53:44','clocktower.jpg','clocktower','assets/HomePageImages/clocktower.jpg',NULL,1,1,1),(18,'Image','2016-10-24 16:53:47','2016-10-24 16:53:47','spokaneclub.jpg','spokaneclub','assets/HomePageImages/spokaneclub.jpg',NULL,1,1,1),(19,'Image','2016-10-24 16:54:14','2016-10-24 16:54:14','shelley.png','shelley','assets/HomePageImages/shelley.png',NULL,1,1,1),(20,'Image','2016-10-27 15:22:01','2016-10-27 15:22:01','Tower-NW-Aerial2-edited.png','Tower NW Aerial2 edited','assets/HomePageImages/Tower-NW-Aerial2-edited.png',NULL,1,1,1),(21,'Image','2016-10-27 15:30:29','2016-10-27 15:30:29','Tower-NW-Aerial2-edited2.png','Tower NW Aerial2 edited2','assets/HomePageImages/Tower-NW-Aerial2-edited2.png',NULL,1,1,1),(22,'Image','2016-11-09 12:04:19','2016-11-09 12:04:19','shutterstock-284794931.jpg','shutterstock 284794931','assets/HomePageImages/shutterstock-284794931.jpg',NULL,1,1,1),(23,'Image','2016-11-09 12:05:30','2016-11-09 12:05:30','shutterstock-284794932.jpg','shutterstock 284794932','assets/HomePageImages/shutterstock-284794932.jpg',NULL,1,1,1),(24,'Folder','2016-11-10 09:11:32','2016-11-10 09:11:32','PDFs','PDFs','assets/PDFs/',NULL,1,0,2),(25,'Image','2016-11-15 14:49:55','2016-11-15 14:49:55','Monroe-Street-Bridge-shot-for-1400-Tower.jpg','Monroe Street Bridge shot for 1400 Tower','assets/HomePageImages/Monroe-Street-Bridge-shot-for-1400-Tower.jpg',NULL,1,1,1),(26,'Image','2016-11-15 14:55:44','2016-11-15 14:55:44','Monroe-Street-Bridge-crop.jpg','Monroe Street Bridge crop','assets/HomePageImages/Monroe-Street-Bridge-crop.jpg',NULL,1,1,1);
/*!40000 ALTER TABLE `File` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Group`
--

DROP TABLE IF EXISTS `Group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Group` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('Group') DEFAULT 'Group',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `Description` mediumtext,
  `Code` varchar(255) DEFAULT NULL,
  `Locked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Sort` int(11) NOT NULL DEFAULT '0',
  `HtmlEditorConfig` mediumtext,
  `ParentID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `ParentID` (`ParentID`),
  KEY `ClassName` (`ClassName`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Group`
--

LOCK TABLES `Group` WRITE;
/*!40000 ALTER TABLE `Group` DISABLE KEYS */;
INSERT INTO `Group` (`ID`, `ClassName`, `LastEdited`, `Created`, `Title`, `Description`, `Code`, `Locked`, `Sort`, `HtmlEditorConfig`, `ParentID`) VALUES (1,'Group','2016-08-25 15:13:19','2016-08-25 15:13:19','Content Authors',NULL,'content-authors',0,1,NULL,0),(2,'Group','2016-08-25 15:13:19','2016-08-25 15:13:19','Administrators',NULL,'administrators',0,0,NULL,0);
/*!40000 ALTER TABLE `Group` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Group_Members`
--

DROP TABLE IF EXISTS `Group_Members`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Group_Members` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `GroupID` int(11) NOT NULL DEFAULT '0',
  `MemberID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `GroupID` (`GroupID`),
  KEY `MemberID` (`MemberID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Group_Members`
--

LOCK TABLES `Group_Members` WRITE;
/*!40000 ALTER TABLE `Group_Members` DISABLE KEYS */;
INSERT INTO `Group_Members` (`ID`, `GroupID`, `MemberID`) VALUES (1,2,1),(2,2,2),(3,2,3);
/*!40000 ALTER TABLE `Group_Members` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Group_Roles`
--

DROP TABLE IF EXISTS `Group_Roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Group_Roles` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `GroupID` int(11) NOT NULL DEFAULT '0',
  `PermissionRoleID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `GroupID` (`GroupID`),
  KEY `PermissionRoleID` (`PermissionRoleID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Group_Roles`
--

LOCK TABLES `Group_Roles` WRITE;
/*!40000 ALTER TABLE `Group_Roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `Group_Roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `HomePage`
--

DROP TABLE IF EXISTS `HomePage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `HomePage` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `BkgdImageID` int(11) NOT NULL DEFAULT '0',
  `CircleImage1ID` int(11) NOT NULL DEFAULT '0',
  `CircleImage2ID` int(11) NOT NULL DEFAULT '0',
  `CircleImage3ID` int(11) NOT NULL DEFAULT '0',
  `CircleImage4ID` int(11) NOT NULL DEFAULT '0',
  `VideoTitle` varchar(45) DEFAULT NULL,
  `VideoEmbedCode` mediumtext,
  `ContactName` varchar(40) DEFAULT NULL,
  `ContactJobTitle` varchar(40) DEFAULT NULL,
  `ContactEmail` varchar(40) DEFAULT NULL,
  `ContactPhone` varchar(40) DEFAULT NULL,
  `ContactInstructions` varchar(128) DEFAULT NULL,
  `ContactImageID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `BkgdImageID` (`BkgdImageID`),
  KEY `CircleImage1ID` (`CircleImage1ID`),
  KEY `CircleImage2ID` (`CircleImage2ID`),
  KEY `CircleImage3ID` (`CircleImage3ID`),
  KEY `CircleImage4ID` (`CircleImage4ID`),
  KEY `ContactImageID` (`ContactImageID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `HomePage`
--

LOCK TABLES `HomePage` WRITE;
/*!40000 ALTER TABLE `HomePage` DISABLE KEYS */;
INSERT INTO `HomePage` (`ID`, `BkgdImageID`, `CircleImage1ID`, `CircleImage2ID`, `CircleImage3ID`, `CircleImage4ID`, `VideoTitle`, `VideoEmbedCode`, `ContactName`, `ContactJobTitle`, `ContactEmail`, `ContactPhone`, `ContactInstructions`, `ContactImageID`) VALUES (1,0,26,16,17,23,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/194084314?autoplay=0&amp;color=9cd6c9&amp;title=0&amp;byline=0&amp;portrait=0\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-991-1000','Contact us for more information or to meet us in person.',19);
/*!40000 ALTER TABLE `HomePage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `HomePage_Live`
--

DROP TABLE IF EXISTS `HomePage_Live`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `HomePage_Live` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `BkgdImageID` int(11) NOT NULL DEFAULT '0',
  `CircleImage1ID` int(11) NOT NULL DEFAULT '0',
  `CircleImage2ID` int(11) NOT NULL DEFAULT '0',
  `CircleImage3ID` int(11) NOT NULL DEFAULT '0',
  `CircleImage4ID` int(11) NOT NULL DEFAULT '0',
  `VideoTitle` varchar(45) DEFAULT NULL,
  `VideoEmbedCode` mediumtext,
  `ContactName` varchar(40) DEFAULT NULL,
  `ContactJobTitle` varchar(40) DEFAULT NULL,
  `ContactEmail` varchar(40) DEFAULT NULL,
  `ContactPhone` varchar(40) DEFAULT NULL,
  `ContactInstructions` varchar(128) DEFAULT NULL,
  `ContactImageID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `BkgdImageID` (`BkgdImageID`),
  KEY `CircleImage1ID` (`CircleImage1ID`),
  KEY `CircleImage2ID` (`CircleImage2ID`),
  KEY `CircleImage3ID` (`CircleImage3ID`),
  KEY `CircleImage4ID` (`CircleImage4ID`),
  KEY `ContactImageID` (`ContactImageID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `HomePage_Live`
--

LOCK TABLES `HomePage_Live` WRITE;
/*!40000 ALTER TABLE `HomePage_Live` DISABLE KEYS */;
INSERT INTO `HomePage_Live` (`ID`, `BkgdImageID`, `CircleImage1ID`, `CircleImage2ID`, `CircleImage3ID`, `CircleImage4ID`, `VideoTitle`, `VideoEmbedCode`, `ContactName`, `ContactJobTitle`, `ContactEmail`, `ContactPhone`, `ContactInstructions`, `ContactImageID`) VALUES (1,0,26,16,17,23,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/194084314?autoplay=0&amp;color=9cd6c9&amp;title=0&amp;byline=0&amp;portrait=0\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-991-1000','Contact us for more information or to meet us in person.',19);
/*!40000 ALTER TABLE `HomePage_Live` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `HomePage_versions`
--

DROP TABLE IF EXISTS `HomePage_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `HomePage_versions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RecordID` int(11) NOT NULL DEFAULT '0',
  `Version` int(11) NOT NULL DEFAULT '0',
  `BkgdImageID` int(11) NOT NULL DEFAULT '0',
  `CircleImage1ID` int(11) NOT NULL DEFAULT '0',
  `CircleImage2ID` int(11) NOT NULL DEFAULT '0',
  `CircleImage3ID` int(11) NOT NULL DEFAULT '0',
  `CircleImage4ID` int(11) NOT NULL DEFAULT '0',
  `VideoTitle` varchar(45) DEFAULT NULL,
  `VideoEmbedCode` mediumtext,
  `ContactName` varchar(40) DEFAULT NULL,
  `ContactJobTitle` varchar(40) DEFAULT NULL,
  `ContactEmail` varchar(40) DEFAULT NULL,
  `ContactPhone` varchar(40) DEFAULT NULL,
  `ContactInstructions` varchar(128) DEFAULT NULL,
  `ContactImageID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `RecordID_Version` (`RecordID`,`Version`),
  KEY `RecordID` (`RecordID`),
  KEY `Version` (`Version`),
  KEY `BkgdImageID` (`BkgdImageID`),
  KEY `CircleImage1ID` (`CircleImage1ID`),
  KEY `CircleImage2ID` (`CircleImage2ID`),
  KEY `CircleImage3ID` (`CircleImage3ID`),
  KEY `CircleImage4ID` (`CircleImage4ID`),
  KEY `ContactImageID` (`ContactImageID`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `HomePage_versions`
--

LOCK TABLES `HomePage_versions` WRITE;
/*!40000 ALTER TABLE `HomePage_versions` DISABLE KEYS */;
INSERT INTO `HomePage_versions` (`ID`, `RecordID`, `Version`, `BkgdImageID`, `CircleImage1ID`, `CircleImage2ID`, `CircleImage3ID`, `CircleImage4ID`, `VideoTitle`, `VideoEmbedCode`, `ContactName`, `ContactJobTitle`, `ContactEmail`, `ContactPhone`, `ContactInstructions`, `ContactImageID`) VALUES (1,1,8,0,4,5,6,7,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),(2,1,9,0,4,5,6,7,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>\r\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Dr&uuml;</a> from <a href=\"https://vimeo.com/user46918195\">Kl&uuml;ndt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>',NULL,NULL,NULL,NULL,NULL,0),(3,1,10,0,4,5,6,7,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-555-1234','Contact us for more information or to schedule a private showing.',0),(4,1,11,0,4,5,6,7,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-555-1234','Contact us for more information or to schedule a private showing.',8),(5,1,12,0,15,16,17,18,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-555-1234','Contact us for more information or to schedule a private showing.',0),(6,1,13,0,15,16,17,18,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-555-1234','Contact us for more information or to schedule a private showing.',19),(7,1,14,0,15,16,17,20,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-555-1234','Contact us for more information or to schedule a private showing.',19),(8,1,15,0,15,16,17,21,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-555-1234','Contact us for more information or to schedule a private showing.',19),(9,1,16,0,15,16,17,21,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-555-1234','Contact us for more information or to schedule a private showing.',19),(10,1,17,0,15,16,17,22,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-555-1234','Contact us for more information or to schedule a private showing.',19),(11,1,18,0,15,16,17,23,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-555-1234','Contact us for more information or to schedule a private showing.',19),(12,1,19,0,15,16,17,23,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-991-1000','Contact us for more information or to meet us in person.',19),(13,1,20,0,0,16,17,23,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-991-1000','Contact us for more information or to meet us in person.',19),(14,1,21,0,26,16,17,23,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/149320091\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n						<p><a href=\"https://vimeo.com/149320091\">The Legend of Caribou Drü</a> from <a href=\"https://vimeo.com/user46918195\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-991-1000','Contact us for more information or to meet us in person.',19),(15,1,22,0,26,16,17,23,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/194084314?color=9cd6c9&amp;title=0&amp;byline=0&amp;portrait=0\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>\n<p><a href=\"https://vimeo.com/194084314\">Experience Spokane on a New Level</a> from <a href=\"https://vimeo.com/klundthosmer\">Klündt | Hosmer</a> on <a href=\"https://vimeo.com\">Vimeo</a>.</p>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-991-1000','Contact us for more information or to meet us in person.',19),(16,1,23,0,26,16,17,23,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/194084314?autoplay=1&amp;color=9cd6c9&amp;title=0&amp;byline=0&amp;portrait=0\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-991-1000','Contact us for more information or to meet us in person.',19),(17,1,24,0,26,16,17,23,'Experience Spokane on a New Level','<iframe src=\"https://player.vimeo.com/video/194084314?autoplay=0&amp;color=9cd6c9&amp;title=0&amp;byline=0&amp;portrait=0\" width=\"640\" height=\"360\" frameborder=\"0\" webkitallowfullscreen=\"\" mozallowfullscreen=\"\" allowfullscreen=\"\"></iframe>','Shelley McDowell','Real Estate Representative','shelley@1400tower.com','509-991-1000','Contact us for more information or to meet us in person.',19);
/*!40000 ALTER TABLE `HomePage_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `LoginAttempt`
--

DROP TABLE IF EXISTS `LoginAttempt`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `LoginAttempt` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('LoginAttempt') DEFAULT 'LoginAttempt',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `Email` varchar(255) DEFAULT NULL,
  `Status` enum('Success','Failure') DEFAULT 'Success',
  `IP` varchar(255) DEFAULT NULL,
  `MemberID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `MemberID` (`MemberID`),
  KEY `ClassName` (`ClassName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `LoginAttempt`
--

LOCK TABLES `LoginAttempt` WRITE;
/*!40000 ALTER TABLE `LoginAttempt` DISABLE KEYS */;
/*!40000 ALTER TABLE `LoginAttempt` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Member`
--

DROP TABLE IF EXISTS `Member`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Member` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('Member') DEFAULT 'Member',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `FirstName` varchar(50) DEFAULT NULL,
  `Surname` varchar(50) DEFAULT NULL,
  `Email` varchar(254) DEFAULT NULL,
  `TempIDHash` varchar(160) DEFAULT NULL,
  `TempIDExpired` datetime DEFAULT NULL,
  `Password` varchar(160) DEFAULT NULL,
  `RememberLoginToken` varchar(160) DEFAULT NULL,
  `NumVisit` int(11) NOT NULL DEFAULT '0',
  `LastVisited` datetime DEFAULT NULL,
  `AutoLoginHash` varchar(160) DEFAULT NULL,
  `AutoLoginExpired` datetime DEFAULT NULL,
  `PasswordEncryption` varchar(50) DEFAULT NULL,
  `Salt` varchar(50) DEFAULT NULL,
  `PasswordExpiry` date DEFAULT NULL,
  `LockedOutUntil` datetime DEFAULT NULL,
  `Locale` varchar(6) DEFAULT NULL,
  `FailedLoginCount` int(11) NOT NULL DEFAULT '0',
  `DateFormat` varchar(30) DEFAULT NULL,
  `TimeFormat` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `Email` (`Email`),
  KEY `ClassName` (`ClassName`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Member`
--

LOCK TABLES `Member` WRITE;
/*!40000 ALTER TABLE `Member` DISABLE KEYS */;
INSERT INTO `Member` (`ID`, `ClassName`, `LastEdited`, `Created`, `FirstName`, `Surname`, `Email`, `TempIDHash`, `TempIDExpired`, `Password`, `RememberLoginToken`, `NumVisit`, `LastVisited`, `AutoLoginHash`, `AutoLoginExpired`, `PasswordEncryption`, `Salt`, `PasswordExpiry`, `LockedOutUntil`, `Locale`, `FailedLoginCount`, `DateFormat`, `TimeFormat`) VALUES (1,'Member','2025-02-24 20:05:59','2016-08-25 15:13:19','Default Admin',NULL,'admin','0ceb72d2e0ee417d879d0d0f29518dd2933754d2','2022-07-02 13:44:43','$2y$10$da47d014c344d7b30c337uFc6Ut6EgS.chPGibCEeYBpvXLO6VtmK',NULL,20,'2022-06-29 17:15:13',NULL,NULL,'blowfish','10$da47d014c344d7b30c3377',NULL,'2025-02-03 13:29:01','en_US',5,'yyyy-MM-dd','H:mm'),(2,'Member','2024-06-02 13:43:51','2016-08-25 16:43:04','Tobby','Hatley','tobby@1400tower.com','044fec8c8d63f23eda810d473acb2c08e30be10f','2024-06-05 13:43:51','$2y$10$6e4f55b9559435de18e8fuLi1JzlSHl6BzsAI31vkan2JWsNn.pla',NULL,19,'2024-06-02 13:45:36',NULL,NULL,'blowfish','10$6e4f55b9559435de18e8f3',NULL,NULL,'en_US',0,'MMM d, yyyy','h:mm a'),(3,'Member','2017-02-09 15:51:32','2016-11-10 09:03:42','shelley','mcdowell','shelley@1400tower.com','cf26cf7cf3c6a039110b2c9fe193f4331e8baefc','2017-02-12 15:51:32','$2y$10$2ee3442ff3ef896f907d6OS7q/LDrY0p9LvRWcFF9bkJyYtF50ki2',NULL,3,'2017-02-09 16:39:28',NULL,NULL,'blowfish','10$2ee3442ff3ef896f907d6c',NULL,NULL,'en_US',0,'MMM d, yyyy','h:mm a');
/*!40000 ALTER TABLE `Member` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `MemberPassword`
--

DROP TABLE IF EXISTS `MemberPassword`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `MemberPassword` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('MemberPassword') DEFAULT 'MemberPassword',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `Password` varchar(160) DEFAULT NULL,
  `Salt` varchar(50) DEFAULT NULL,
  `PasswordEncryption` varchar(50) DEFAULT NULL,
  `MemberID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `MemberID` (`MemberID`),
  KEY `ClassName` (`ClassName`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `MemberPassword`
--

LOCK TABLES `MemberPassword` WRITE;
/*!40000 ALTER TABLE `MemberPassword` DISABLE KEYS */;
INSERT INTO `MemberPassword` (`ID`, `ClassName`, `LastEdited`, `Created`, `Password`, `Salt`, `PasswordEncryption`, `MemberID`) VALUES (1,'MemberPassword','2016-08-25 16:43:05','2016-08-25 16:43:05','$2y$10$f014e55e522ebcf636faduYfwVrnTb9uUr.D8xG19W9sqlC6U2/JS','10$f014e55e522ebcf636fad8','blowfish',2),(2,'MemberPassword','2016-11-10 09:03:43','2016-11-10 09:03:43','$2y$10$2ee3442ff3ef896f907d6OS7q/LDrY0p9LvRWcFF9bkJyYtF50ki2','10$2ee3442ff3ef896f907d6c','blowfish',3),(3,'MemberPassword','2016-11-10 09:07:35','2016-11-10 09:07:35','$2y$10$6e4f55b9559435de18e8fuLi1JzlSHl6BzsAI31vkan2JWsNn.pla','10$6e4f55b9559435de18e8f3','blowfish',2),(4,'MemberPassword','2020-07-15 14:23:09','2020-07-15 14:23:09','$2y$10$da47d014c344d7b30c337uFc6Ut6EgS.chPGibCEeYBpvXLO6VtmK','10$da47d014c344d7b30c3377','blowfish',1);
/*!40000 ALTER TABLE `MemberPassword` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `Permission`
--

DROP TABLE IF EXISTS `Permission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `Permission` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('Permission') DEFAULT 'Permission',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `Code` varchar(255) DEFAULT NULL,
  `Arg` int(11) NOT NULL DEFAULT '0',
  `Type` int(11) NOT NULL DEFAULT '1',
  `GroupID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `GroupID` (`GroupID`),
  KEY `Code` (`Code`),
  KEY `ClassName` (`ClassName`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `Permission`
--

LOCK TABLES `Permission` WRITE;
/*!40000 ALTER TABLE `Permission` DISABLE KEYS */;
INSERT INTO `Permission` (`ID`, `ClassName`, `LastEdited`, `Created`, `Code`, `Arg`, `Type`, `GroupID`) VALUES (1,'Permission','2016-08-25 15:13:19','2016-08-25 15:13:19','CMS_ACCESS_CMSMain',0,1,1),(2,'Permission','2016-08-25 15:13:19','2016-08-25 15:13:19','CMS_ACCESS_AssetAdmin',0,1,1),(3,'Permission','2016-08-25 15:13:19','2016-08-25 15:13:19','CMS_ACCESS_ReportAdmin',0,1,1),(4,'Permission','2016-08-25 15:13:19','2016-08-25 15:13:19','SITETREE_REORGANISE',0,1,1),(5,'Permission','2016-08-25 15:13:19','2016-08-25 15:13:19','ADMIN',0,1,2);
/*!40000 ALTER TABLE `Permission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PermissionRole`
--

DROP TABLE IF EXISTS `PermissionRole`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PermissionRole` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('PermissionRole') DEFAULT 'PermissionRole',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `Title` varchar(50) DEFAULT NULL,
  `OnlyAdminCanApply` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `ClassName` (`ClassName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PermissionRole`
--

LOCK TABLES `PermissionRole` WRITE;
/*!40000 ALTER TABLE `PermissionRole` DISABLE KEYS */;
/*!40000 ALTER TABLE `PermissionRole` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PermissionRoleCode`
--

DROP TABLE IF EXISTS `PermissionRoleCode`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PermissionRoleCode` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('PermissionRoleCode') DEFAULT 'PermissionRoleCode',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `Code` varchar(50) DEFAULT NULL,
  `RoleID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `RoleID` (`RoleID`),
  KEY `ClassName` (`ClassName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PermissionRoleCode`
--

LOCK TABLES `PermissionRoleCode` WRITE;
/*!40000 ALTER TABLE `PermissionRoleCode` DISABLE KEYS */;
/*!40000 ALTER TABLE `PermissionRoleCode` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PlaceHolderPage`
--

DROP TABLE IF EXISTS `PlaceHolderPage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PlaceHolderPage` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RedirectFirstChild` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PlaceHolderPage`
--

LOCK TABLES `PlaceHolderPage` WRITE;
/*!40000 ALTER TABLE `PlaceHolderPage` DISABLE KEYS */;
INSERT INTO `PlaceHolderPage` (`ID`, `RedirectFirstChild`) VALUES (13,0);
/*!40000 ALTER TABLE `PlaceHolderPage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PlaceHolderPage_Live`
--

DROP TABLE IF EXISTS `PlaceHolderPage_Live`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PlaceHolderPage_Live` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RedirectFirstChild` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PlaceHolderPage_Live`
--

LOCK TABLES `PlaceHolderPage_Live` WRITE;
/*!40000 ALTER TABLE `PlaceHolderPage_Live` DISABLE KEYS */;
INSERT INTO `PlaceHolderPage_Live` (`ID`, `RedirectFirstChild`) VALUES (13,0);
/*!40000 ALTER TABLE `PlaceHolderPage_Live` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `PlaceHolderPage_versions`
--

DROP TABLE IF EXISTS `PlaceHolderPage_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `PlaceHolderPage_versions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RecordID` int(11) NOT NULL DEFAULT '0',
  `Version` int(11) NOT NULL DEFAULT '0',
  `RedirectFirstChild` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `RecordID_Version` (`RecordID`,`Version`),
  KEY `RecordID` (`RecordID`),
  KEY `Version` (`Version`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `PlaceHolderPage_versions`
--

LOCK TABLES `PlaceHolderPage_versions` WRITE;
/*!40000 ALTER TABLE `PlaceHolderPage_versions` DISABLE KEYS */;
INSERT INTO `PlaceHolderPage_versions` (`ID`, `RecordID`, `Version`, `RedirectFirstChild`) VALUES (1,13,1,0),(2,13,2,0),(3,13,3,0),(4,13,4,0);
/*!40000 ALTER TABLE `PlaceHolderPage_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `RedirectorPage`
--

DROP TABLE IF EXISTS `RedirectorPage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RedirectorPage` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RedirectionType` enum('Internal','External') DEFAULT 'Internal',
  `ExternalURL` varchar(2083) DEFAULT NULL,
  `LinkToID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `LinkToID` (`LinkToID`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `RedirectorPage`
--

LOCK TABLES `RedirectorPage` WRITE;
/*!40000 ALTER TABLE `RedirectorPage` DISABLE KEYS */;
INSERT INTO `RedirectorPage` (`ID`, `RedirectionType`, `ExternalURL`, `LinkToID`) VALUES (16,'Internal',NULL,15);
/*!40000 ALTER TABLE `RedirectorPage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `RedirectorPage_Live`
--

DROP TABLE IF EXISTS `RedirectorPage_Live`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RedirectorPage_Live` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RedirectionType` enum('Internal','External') DEFAULT 'Internal',
  `ExternalURL` varchar(2083) DEFAULT NULL,
  `LinkToID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `LinkToID` (`LinkToID`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `RedirectorPage_Live`
--

LOCK TABLES `RedirectorPage_Live` WRITE;
/*!40000 ALTER TABLE `RedirectorPage_Live` DISABLE KEYS */;
INSERT INTO `RedirectorPage_Live` (`ID`, `RedirectionType`, `ExternalURL`, `LinkToID`) VALUES (16,'Internal',NULL,15);
/*!40000 ALTER TABLE `RedirectorPage_Live` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `RedirectorPage_versions`
--

DROP TABLE IF EXISTS `RedirectorPage_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `RedirectorPage_versions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RecordID` int(11) NOT NULL DEFAULT '0',
  `Version` int(11) NOT NULL DEFAULT '0',
  `RedirectionType` enum('Internal','External') DEFAULT 'Internal',
  `ExternalURL` varchar(2083) DEFAULT NULL,
  `LinkToID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `RecordID_Version` (`RecordID`,`Version`),
  KEY `RecordID` (`RecordID`),
  KEY `Version` (`Version`),
  KEY `LinkToID` (`LinkToID`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `RedirectorPage_versions`
--

LOCK TABLES `RedirectorPage_versions` WRITE;
/*!40000 ALTER TABLE `RedirectorPage_versions` DISABLE KEYS */;
INSERT INTO `RedirectorPage_versions` (`ID`, `RecordID`, `Version`, `RedirectionType`, `ExternalURL`, `LinkToID`) VALUES (1,16,1,'Internal',NULL,0),(2,16,2,'Internal',NULL,15),(3,16,3,'Internal',NULL,15);
/*!40000 ALTER TABLE `RedirectorPage_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteConfig`
--

DROP TABLE IF EXISTS `SiteConfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteConfig` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('SiteConfig') DEFAULT 'SiteConfig',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `Tagline` varchar(255) DEFAULT NULL,
  `Theme` varchar(255) DEFAULT NULL,
  `CanViewType` enum('Anyone','LoggedInUsers','OnlyTheseUsers') DEFAULT 'Anyone',
  `CanEditType` enum('LoggedInUsers','OnlyTheseUsers') DEFAULT 'LoggedInUsers',
  `CanCreateTopLevelType` enum('LoggedInUsers','OnlyTheseUsers') DEFAULT 'LoggedInUsers',
  PRIMARY KEY (`ID`),
  KEY `ClassName` (`ClassName`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteConfig`
--

LOCK TABLES `SiteConfig` WRITE;
/*!40000 ALTER TABLE `SiteConfig` DISABLE KEYS */;
INSERT INTO `SiteConfig` (`ID`, `ClassName`, `LastEdited`, `Created`, `Title`, `Tagline`, `Theme`, `CanViewType`, `CanEditType`, `CanCreateTopLevelType`) VALUES (1,'SiteConfig','2016-08-25 15:18:12','2016-08-25 15:13:19','1400 Tower',NULL,'1400tower','Anyone','LoggedInUsers','LoggedInUsers');
/*!40000 ALTER TABLE `SiteConfig` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteConfig_CreateTopLevelGroups`
--

DROP TABLE IF EXISTS `SiteConfig_CreateTopLevelGroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteConfig_CreateTopLevelGroups` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SiteConfigID` int(11) NOT NULL DEFAULT '0',
  `GroupID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `SiteConfigID` (`SiteConfigID`),
  KEY `GroupID` (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteConfig_CreateTopLevelGroups`
--

LOCK TABLES `SiteConfig_CreateTopLevelGroups` WRITE;
/*!40000 ALTER TABLE `SiteConfig_CreateTopLevelGroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `SiteConfig_CreateTopLevelGroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteConfig_EditorGroups`
--

DROP TABLE IF EXISTS `SiteConfig_EditorGroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteConfig_EditorGroups` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SiteConfigID` int(11) NOT NULL DEFAULT '0',
  `GroupID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `SiteConfigID` (`SiteConfigID`),
  KEY `GroupID` (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteConfig_EditorGroups`
--

LOCK TABLES `SiteConfig_EditorGroups` WRITE;
/*!40000 ALTER TABLE `SiteConfig_EditorGroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `SiteConfig_EditorGroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteConfig_ViewerGroups`
--

DROP TABLE IF EXISTS `SiteConfig_ViewerGroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteConfig_ViewerGroups` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SiteConfigID` int(11) NOT NULL DEFAULT '0',
  `GroupID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `SiteConfigID` (`SiteConfigID`),
  KEY `GroupID` (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteConfig_ViewerGroups`
--

LOCK TABLES `SiteConfig_ViewerGroups` WRITE;
/*!40000 ALTER TABLE `SiteConfig_ViewerGroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `SiteConfig_ViewerGroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteTree`
--

DROP TABLE IF EXISTS `SiteTree`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteTree` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('SiteTree','Page','BioHolderPage','BioPage','HomePage','ErrorPage','RedirectorPage','VirtualPage','PlaceHolderPage') DEFAULT 'SiteTree',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `URLSegment` varchar(255) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `MenuTitle` varchar(100) DEFAULT NULL,
  `Content` mediumtext,
  `MetaDescription` mediumtext,
  `ExtraMeta` mediumtext,
  `ShowInMenus` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ShowInSearch` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Sort` int(11) NOT NULL DEFAULT '0',
  `HasBrokenFile` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `HasBrokenLink` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ReportClass` varchar(50) DEFAULT NULL,
  `CanViewType` enum('Anyone','LoggedInUsers','OnlyTheseUsers','Inherit') DEFAULT 'Inherit',
  `CanEditType` enum('LoggedInUsers','OnlyTheseUsers','Inherit') DEFAULT 'Inherit',
  `Priority` varchar(5) DEFAULT NULL,
  `MetaTitle` varchar(255) DEFAULT NULL,
  `Version` int(11) NOT NULL DEFAULT '0',
  `ParentID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `ParentID` (`ParentID`),
  KEY `URLSegment` (`URLSegment`),
  KEY `ClassName` (`ClassName`),
  FULLTEXT KEY `SearchFields` (`Title`,`MenuTitle`,`Content`,`MetaDescription`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteTree`
--

LOCK TABLES `SiteTree` WRITE;
/*!40000 ALTER TABLE `SiteTree` DISABLE KEYS */;
INSERT INTO `SiteTree` (`ID`, `ClassName`, `LastEdited`, `Created`, `URLSegment`, `Title`, `MenuTitle`, `Content`, `MetaDescription`, `ExtraMeta`, `ShowInMenus`, `ShowInSearch`, `Sort`, `HasBrokenFile`, `HasBrokenLink`, `ReportClass`, `CanViewType`, `CanEditType`, `Priority`, `MetaTitle`, `Version`, `ParentID`) VALUES (1,'HomePage','2016-12-05 16:52:53','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,24,0),(2,'BioHolderPage','2016-11-10 09:53:22','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants and enjoying the city’s first class entertainment venues. 1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.” Amenities will also include secure, climate controlled parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all units. </p><h2>1400 Principals</h2><p class=\"highlight\">1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,12,0),(3,'Page','2016-11-10 09:32:40','2016-08-25 15:13:19','contact-us','Contact Us',NULL,'<p>For more information about 1400 Tower please contact us at:</p><p><a href=\"mailto:info@1400tower.com\">info@1400tower.com</a> or call 509-991-1000</p>',NULL,NULL,1,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,4,0),(4,'ErrorPage','2016-08-25 15:13:19','2016-08-25 15:13:19','page-not-found','Page not found',NULL,'<p>Sorry, it seems you were trying to access a page that doesn\'t exist.</p><p>Please check the spelling of the URL you were trying to access and try again.</p>',NULL,NULL,0,0,7,0,0,NULL,'Inherit','Inherit',NULL,NULL,1,0),(5,'ErrorPage','2016-08-25 15:13:19','2016-08-25 15:13:19','server-error','Server error',NULL,'<p>Sorry, there was a problem with handling your request.</p>',NULL,NULL,0,0,8,0,0,NULL,'Inherit','Inherit',NULL,NULL,1,0),(7,'BioPage','2016-11-01 16:33:43','2016-08-25 16:27:59','mick-mcdowell','MICK McDOWELL',NULL,'<p>Mick McDowell is a highly experienced and well qualified developer, builder and community leader.  Over the past 40 years, Mick has purchased and restored almost 30 buildings in downtown Spokane all of which continue to successfully operate today.  His landmark project is the five story Banner Bank building near the Division Street gateway in downtown. In addition, Mick sits on the Spokane Public Facility District Board of Directors and chairs the Project Committee which oversaw the recently completed multi-million dollar Spokane Convention Center expansion effort.  He also served as chair of the Downtown Spokane Partnership.  Mick began his developer’s career while working as a full-time firefighter with the Spokane Fire Department and served 20 years with distinction before retiring to concentrate on his other interests.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,10,2),(8,'BioPage','2016-11-01 16:39:16','2016-08-25 16:28:14','shelley-mcdowell','SHELLEY McDOWELL',NULL,'<p>Shelley McDowell is a licensed Real Estate Managing Broker, developer and former investment advisor.   A life-long Spokane resident, Shelley holds a Bachelor of Science in Business Administration from the University of the State of NY, Albany and is currently the Branch Manager for Century 21 Beutler &amp; Associates Spokane office.  Shelley spent 10 years as an investment advisor before partnering with her husband Mick to develop almost 30 downtown Spokane projects and manage over 800 apartment units.  Shelley continues to help Mick own and operate downtown’s Banner Bank building. </p><p>Shelley’s also very community minded.  She’s a past YMCA board member, past board member and Chair of the Spokane Club, Past President and board member of EWI of Spokane and currently sits on the Riverbank Board of Directors as a founding member.</p><p>Summers find Shelley enjoying mountain biking, boating, swimming and hiking.   She spends the cooler weather in spinning classes, sitting by cozy fires and sipping fine wines. </p>',NULL,NULL,0,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,11,2),(9,'BioPage','2016-11-01 16:42:26','2016-08-25 16:28:27','anton-c-delateur','ANTON C. DeLATEUR',NULL,'<p>Anton DeLateur is a Spokane businessman and Financial Advisor and a long-time supporter of various business, educational and charitable interests.  He brings over 36 years of experience in finance and organization to our enterprise.  Anton earned a BA in Philosophy and Classical languages from St. Thomas in Seattle in 1967 and a Licentiate in Philosophy from Gonzaga University.  He also taught Classical languages and music at Gonzaga Prep and JFK Memorial High School in Seattle from 1969 to 1979 before joining the financial world.  He has served on the board of Morningstar Boys Ranch, is advisor to St. Joseph’s Family Center, and has been an ardent supporter of local music and marching band organizations. </p>',NULL,NULL,0,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,9,2),(10,'BioPage','2016-11-01 16:45:29','2016-08-25 16:28:46','donald-howell','DONALD HOWELL',NULL,'<p>Don Howell has been involved in a broad spectrum of highly varied real estate and business related activities spanning an almost 40 career of corporate and personal business enterprises.  Don’s successful efforts include a 31-year management position career with a national title and escrow company, numerous private property investment opportunities including acquisition and operating a private equity financing company, a manufacturing company, commercial property acquisition and renovation, and residential home construction enterprise.  Don is an active member of Spokane Rotary 21 and current chair of the Priest Lake Memory Garden project.</p>',NULL,NULL,0,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,10,2),(11,'BioPage','2016-10-24 16:33:24','2016-08-25 16:29:02','tobby-hatley','TOBBY HATLEY',NULL,'<p>Tobby Hatley has more than 30 years of media and public affairs experience having worked in TV, radio print, politics and marketing. He is 1400 Tower\'s communications manager.</p><p>Tobby began his career in 1978 in broadcast sales after earning a BA in Radio and TV Management from Eastern Washington University. Tobby learned the ins and outs of politics, legislative issues and public affairs while covering state and local governments in Washington, Idaho and Montana as well as the U.S. Congress in Washington, D.C.  Tobby became most familiar to Inland Northwest residents as a broadcast journalist during his 14 years with KHQ-TV in Spokane.  </p><p>Tobby has a Master’s degree in Communications with an emphasis in Journalism and Public Affairs from The American University in Washington, D.C. </p><p> </p><p> </p>',NULL,NULL,0,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,8,2),(13,'PlaceHolderPage','2016-10-19 17:05:01','2016-08-25 16:35:05','footer-links','Footer Links',NULL,NULL,NULL,NULL,0,0,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,4,0),(15,'Page','2016-10-24 16:38:57','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,'<p>Last update: October 24, 2016</p><p>Your privacy is important to us. This privacy policy discusses how and why we collect information from you and what we do with it. This Privacy Policy applies to our website, 1400tower.com.</p><h2>Collection of Information</h2><p><strong>Personal Information</strong> You may submit to us personal information that identifies you as an individual when you choose to interact with us on this website. Personal information that you may submit includes your name, e-mail address, postal address and telephone number. In some cases, you may also submit demographic information such as your age, gender, zip code, level of education, household income, and interests. If we combine demographic information with your personal information, we will treat it as personal information as set forth in this Privacy Statement. In some cases, you may provide additional information including when you choose to personalize your use of our website for medical conditions of interest, when you ask a question of our experts, or when you contact our customer support group.</p><p><strong>Personal Information Provided When Requesting Information</strong> On this website you will find web forms where you are requested to submit personal information in order to be contacted by our Sales and/or Marketing Department. When you submit your personal information via such forms, we will make our best effort to protect your personal information in accordance with our privacy and information security policies.</p><p><strong>Children\'s Personal Information</strong> We do not knowingly collect personally identifiable information from users under the age of 13. If we find out that we have such personal information, we will take reasonable steps to delete it.</p><p><strong>Website Usage Information</strong> Our website collects non-personally identifiable information such as navigational data (log files, server logs, click-stream) and information about how our website is used by you (through cookies or web beacons, etc.). We may also collect information such as the URL of the website you previously visited and the time of day that you use our website. Analytics information also keeps track of the pages you visit within our website. You can set your browser to notify you when a cookie is sent, or to refuse or delete cookies altogether, but in such cases many features of our website will not function as designed. Additional information is collected through AdWords Remarketing. AdWords Remarketing is a Remarketing and Behavioral Targeting service provided by Google. It connects the activity of 1400tower.com with the Adwords advertising network and the Doubleclick Cookie. <a href=\"https://www.google.com/settings/ads/onweb#display_optout\">You can opt out of the cookie tracking here.</a></p><h2>How We Use Your Information</h2><p><strong>Personal Information</strong> We use the personal information that you submit to help enhance and personalize your use of our website. This information also allows us to provide you with relevant information, content, and advertising (on our website, in newsletters, via e-mail, etc.).</p><p>When you respond to an offer of information or a service on our website (for example, by completing an online form), we may use that information to connect you to a specific provider or with a trusted partner who will provide the information or service that you requested.</p><p>We may also use your personal information to respond to your inquiries, send you service e-mails or follow-up with a phone call with important information regarding our website and related services, and to send you newsletters and offers.</p><p><strong>Non-Personal Information</strong> We use anonymous and aggregated data to create statistics and reports for various business purposes. We may aggregate anonymous data and share it with our advertisers or partners in order to offer you potentially desirable content, products, and services.</p><p>The website usage information we collect is used to monitor and improve the operation, technical functions, and quality of our website and services. This data is also used to deliver customized content and advertising to you when your online behavior indicates that you are interested in a particular subject area.</p><p><strong>Disclosure of Data</strong> We do not disclose your personal information to third parties except under certain circumstances. Set forth below are various circumstances under which we may disclose your personal information:</p><ul><li>Certain employees of ours and independent contractors we work with have access to your personally identifiable information for the sole purpose of helping us run our business. These employees and contractors have confidentiality and security obligations.</li>\n<li>We may disclose your information to third parties who provide services, such as (but not limited to): contact information verification, payment processing, customer service, website hosting, and email delivery services.</li>\n<li>We may disclose your information to another business entity should we plan to merge with or be acquired by that business entity; or to any organization involved in a merger, transfer, or sale of our assets or business.</li>\n<li>We may also disclose your personally identifiable information to respond to law enforcement requests, court orders, or other legal processes; or if we believe that such disclosure is necessary to investigate, prevent, or respond to illegal activities, fraud, physical threats to you, others, or to yourself; or as otherwise required by any applicable law or regulation.</li>\n</ul><p>Before we disclose your personally identifiable information for other reasons, we will first obtain your consent, via e-mail, click-through, an online opportunity to enter your preference, or some other manner.</p><p>In the event that we disclose your personally identifiable information in accordance with this section (\"Disclosure of Data\"), we will require third parties to take appropriate measures to protect and maintain the privacy and confidentiality of your personally identifiable information.</p><p><strong>Prohibited Disclosures</strong> Except as set forth above, we will not disclose your personally identifiable information to any third party without your explicit consent. In addition, we will not sell, rent, or otherwise disclose our e-mail list or address list except as explicitly set forth in this Statement.</p><h2>Control of Your Personal Information</h2><p>Our customers may choose whether to provide personally identifiable information at the time of collection. In addition, customers may stop the delivery of future e-mail communications by unsubscribing at any time. For instance, each e-mail you receive (aside from \"service e-mails\") contains instructions explaining how to stop receiving such e-mails.</p><p>If your personally identifiable information (such as zip code, phone, or e-mail or postal address) changes, or if you no longer desire our service, we provide a way for you to correct, update, or delete/deactivate your personally identifiable information.</p><h2>Protection of Information—Security</h2><p>We are committed to the protection of your personal information. We use a variety of security technologies and procedures to help protect your personal information from unauthorized access, use, or disclosure.</p><p>You should keep in mind that no Internet communication is ever completely secure or error-free.</p><h2>Changes to This Statement</h2><p>We may periodically update this Statement to reflect changes in our services and policies. When we post changes to this Statement, we will revise the \"last updated\" date at the top of this Statement. If there are material changes to the Statement or in how we will use your personal information, we will notify you either by posting a prominent notice prior to implementing the change or by sending you a direct notification. We encourage you to periodically review this Statement to be informed of how we are protecting your information.</p><h2>Contact Information</h2><p>If you have questions or complaints regarding this Statement, you should contact us at</p><p>1400 Tower<br> 1400 West Riverside Ave<br> Spokane, WA 99201<br> United States</p><p>+1 (509) 555-1234</p>',NULL,NULL,0,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,11,2),(16,'RedirectorPage','2016-10-19 17:04:27','2016-08-25 16:36:48','privacy-policy','Privacy Policy',NULL,NULL,NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,3,13);
/*!40000 ALTER TABLE `SiteTree` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteTree_EditorGroups`
--

DROP TABLE IF EXISTS `SiteTree_EditorGroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteTree_EditorGroups` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SiteTreeID` int(11) NOT NULL DEFAULT '0',
  `GroupID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `SiteTreeID` (`SiteTreeID`),
  KEY `GroupID` (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteTree_EditorGroups`
--

LOCK TABLES `SiteTree_EditorGroups` WRITE;
/*!40000 ALTER TABLE `SiteTree_EditorGroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `SiteTree_EditorGroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteTree_ImageTracking`
--

DROP TABLE IF EXISTS `SiteTree_ImageTracking`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteTree_ImageTracking` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SiteTreeID` int(11) NOT NULL DEFAULT '0',
  `FileID` int(11) NOT NULL DEFAULT '0',
  `FieldName` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `SiteTreeID` (`SiteTreeID`),
  KEY `FileID` (`FileID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteTree_ImageTracking`
--

LOCK TABLES `SiteTree_ImageTracking` WRITE;
/*!40000 ALTER TABLE `SiteTree_ImageTracking` DISABLE KEYS */;
/*!40000 ALTER TABLE `SiteTree_ImageTracking` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteTree_LinkTracking`
--

DROP TABLE IF EXISTS `SiteTree_LinkTracking`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteTree_LinkTracking` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SiteTreeID` int(11) NOT NULL DEFAULT '0',
  `ChildID` int(11) NOT NULL DEFAULT '0',
  `FieldName` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `SiteTreeID` (`SiteTreeID`),
  KEY `ChildID` (`ChildID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteTree_LinkTracking`
--

LOCK TABLES `SiteTree_LinkTracking` WRITE;
/*!40000 ALTER TABLE `SiteTree_LinkTracking` DISABLE KEYS */;
/*!40000 ALTER TABLE `SiteTree_LinkTracking` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteTree_Live`
--

DROP TABLE IF EXISTS `SiteTree_Live`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteTree_Live` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `ClassName` enum('SiteTree','Page','BioHolderPage','BioPage','HomePage','ErrorPage','RedirectorPage','VirtualPage','PlaceHolderPage') DEFAULT 'SiteTree',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `URLSegment` varchar(255) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `MenuTitle` varchar(100) DEFAULT NULL,
  `Content` mediumtext,
  `MetaDescription` mediumtext,
  `ExtraMeta` mediumtext,
  `ShowInMenus` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ShowInSearch` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Sort` int(11) NOT NULL DEFAULT '0',
  `HasBrokenFile` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `HasBrokenLink` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ReportClass` varchar(50) DEFAULT NULL,
  `CanViewType` enum('Anyone','LoggedInUsers','OnlyTheseUsers','Inherit') DEFAULT 'Inherit',
  `CanEditType` enum('LoggedInUsers','OnlyTheseUsers','Inherit') DEFAULT 'Inherit',
  `Priority` varchar(5) DEFAULT NULL,
  `MetaTitle` varchar(255) DEFAULT NULL,
  `Version` int(11) NOT NULL DEFAULT '0',
  `ParentID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `ParentID` (`ParentID`),
  KEY `URLSegment` (`URLSegment`),
  KEY `ClassName` (`ClassName`),
  FULLTEXT KEY `SearchFields` (`Title`,`MenuTitle`,`Content`,`MetaDescription`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteTree_Live`
--

LOCK TABLES `SiteTree_Live` WRITE;
/*!40000 ALTER TABLE `SiteTree_Live` DISABLE KEYS */;
INSERT INTO `SiteTree_Live` (`ID`, `ClassName`, `LastEdited`, `Created`, `URLSegment`, `Title`, `MenuTitle`, `Content`, `MetaDescription`, `ExtraMeta`, `ShowInMenus`, `ShowInSearch`, `Sort`, `HasBrokenFile`, `HasBrokenLink`, `ReportClass`, `CanViewType`, `CanEditType`, `Priority`, `MetaTitle`, `Version`, `ParentID`) VALUES (1,'HomePage','2016-12-05 16:52:53','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,24,0),(2,'BioHolderPage','2016-11-10 09:53:22','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants and enjoying the city’s first class entertainment venues. 1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.” Amenities will also include secure, climate controlled parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all units. </p><h2>1400 Principals</h2><p class=\"highlight\">1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,12,0),(3,'Page','2016-11-10 09:32:40','2016-08-25 15:13:19','contact-us','Contact Us',NULL,'<p>For more information about 1400 Tower please contact us at:</p><p><a href=\"mailto:info@1400tower.com\">info@1400tower.com</a> or call 509-991-1000</p>',NULL,NULL,1,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,4,0),(4,'ErrorPage','2016-08-25 15:13:19','2016-08-25 15:13:19','page-not-found','Page not found',NULL,'<p>Sorry, it seems you were trying to access a page that doesn\'t exist.</p><p>Please check the spelling of the URL you were trying to access and try again.</p>',NULL,NULL,0,0,7,0,0,NULL,'Inherit','Inherit',NULL,NULL,1,0),(5,'ErrorPage','2016-08-25 15:13:19','2016-08-25 15:13:19','server-error','Server error',NULL,'<p>Sorry, there was a problem with handling your request.</p>',NULL,NULL,0,0,8,0,0,NULL,'Inherit','Inherit',NULL,NULL,1,0),(7,'BioPage','2016-11-01 16:33:43','2016-08-25 16:27:59','mick-mcdowell','MICK McDOWELL',NULL,'<p>Mick McDowell is a highly experienced and well qualified developer, builder and community leader.  Over the past 40 years, Mick has purchased and restored almost 30 buildings in downtown Spokane all of which continue to successfully operate today.  His landmark project is the five story Banner Bank building near the Division Street gateway in downtown. In addition, Mick sits on the Spokane Public Facility District Board of Directors and chairs the Project Committee which oversaw the recently completed multi-million dollar Spokane Convention Center expansion effort.  He also served as chair of the Downtown Spokane Partnership.  Mick began his developer’s career while working as a full-time firefighter with the Spokane Fire Department and served 20 years with distinction before retiring to concentrate on his other interests.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,10,2),(8,'BioPage','2016-11-01 16:39:16','2016-08-25 16:28:14','shelley-mcdowell','SHELLEY McDOWELL',NULL,'<p>Shelley McDowell is a licensed Real Estate Managing Broker, developer and former investment advisor.   A life-long Spokane resident, Shelley holds a Bachelor of Science in Business Administration from the University of the State of NY, Albany and is currently the Branch Manager for Century 21 Beutler &amp; Associates Spokane office.  Shelley spent 10 years as an investment advisor before partnering with her husband Mick to develop almost 30 downtown Spokane projects and manage over 800 apartment units.  Shelley continues to help Mick own and operate downtown’s Banner Bank building. </p><p>Shelley’s also very community minded.  She’s a past YMCA board member, past board member and Chair of the Spokane Club, Past President and board member of EWI of Spokane and currently sits on the Riverbank Board of Directors as a founding member.</p><p>Summers find Shelley enjoying mountain biking, boating, swimming and hiking.   She spends the cooler weather in spinning classes, sitting by cozy fires and sipping fine wines. </p>',NULL,NULL,0,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,11,2),(9,'BioPage','2016-11-01 16:42:26','2016-08-25 16:28:27','anton-c-delateur','ANTON C. DeLATEUR',NULL,'<p>Anton DeLateur is a Spokane businessman and Financial Advisor and a long-time supporter of various business, educational and charitable interests.  He brings over 36 years of experience in finance and organization to our enterprise.  Anton earned a BA in Philosophy and Classical languages from St. Thomas in Seattle in 1967 and a Licentiate in Philosophy from Gonzaga University.  He also taught Classical languages and music at Gonzaga Prep and JFK Memorial High School in Seattle from 1969 to 1979 before joining the financial world.  He has served on the board of Morningstar Boys Ranch, is advisor to St. Joseph’s Family Center, and has been an ardent supporter of local music and marching band organizations. </p>',NULL,NULL,0,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,9,2),(10,'BioPage','2016-11-01 16:45:29','2016-08-25 16:28:46','donald-howell','DONALD HOWELL',NULL,'<p>Don Howell has been involved in a broad spectrum of highly varied real estate and business related activities spanning an almost 40 career of corporate and personal business enterprises.  Don’s successful efforts include a 31-year management position career with a national title and escrow company, numerous private property investment opportunities including acquisition and operating a private equity financing company, a manufacturing company, commercial property acquisition and renovation, and residential home construction enterprise.  Don is an active member of Spokane Rotary 21 and current chair of the Priest Lake Memory Garden project.</p>',NULL,NULL,0,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,10,2),(11,'BioPage','2016-10-24 16:33:24','2016-08-25 16:29:02','tobby-hatley','TOBBY HATLEY',NULL,'<p>Tobby Hatley has more than 30 years of media and public affairs experience having worked in TV, radio print, politics and marketing. He is 1400 Tower\'s communications manager.</p><p>Tobby began his career in 1978 in broadcast sales after earning a BA in Radio and TV Management from Eastern Washington University. Tobby learned the ins and outs of politics, legislative issues and public affairs while covering state and local governments in Washington, Idaho and Montana as well as the U.S. Congress in Washington, D.C.  Tobby became most familiar to Inland Northwest residents as a broadcast journalist during his 14 years with KHQ-TV in Spokane.  </p><p>Tobby has a Master’s degree in Communications with an emphasis in Journalism and Public Affairs from The American University in Washington, D.C. </p><p> </p><p> </p>',NULL,NULL,0,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,8,2),(13,'PlaceHolderPage','2016-10-19 17:05:01','2016-08-25 16:35:05','footer-links','Footer Links',NULL,NULL,NULL,NULL,0,0,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,4,0),(15,'Page','2016-10-24 16:38:57','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,'<p>Last update: October 24, 2016</p><p>Your privacy is important to us. This privacy policy discusses how and why we collect information from you and what we do with it. This Privacy Policy applies to our website, 1400tower.com.</p><h2>Collection of Information</h2><p><strong>Personal Information</strong> You may submit to us personal information that identifies you as an individual when you choose to interact with us on this website. Personal information that you may submit includes your name, e-mail address, postal address and telephone number. In some cases, you may also submit demographic information such as your age, gender, zip code, level of education, household income, and interests. If we combine demographic information with your personal information, we will treat it as personal information as set forth in this Privacy Statement. In some cases, you may provide additional information including when you choose to personalize your use of our website for medical conditions of interest, when you ask a question of our experts, or when you contact our customer support group.</p><p><strong>Personal Information Provided When Requesting Information</strong> On this website you will find web forms where you are requested to submit personal information in order to be contacted by our Sales and/or Marketing Department. When you submit your personal information via such forms, we will make our best effort to protect your personal information in accordance with our privacy and information security policies.</p><p><strong>Children\'s Personal Information</strong> We do not knowingly collect personally identifiable information from users under the age of 13. If we find out that we have such personal information, we will take reasonable steps to delete it.</p><p><strong>Website Usage Information</strong> Our website collects non-personally identifiable information such as navigational data (log files, server logs, click-stream) and information about how our website is used by you (through cookies or web beacons, etc.). We may also collect information such as the URL of the website you previously visited and the time of day that you use our website. Analytics information also keeps track of the pages you visit within our website. You can set your browser to notify you when a cookie is sent, or to refuse or delete cookies altogether, but in such cases many features of our website will not function as designed. Additional information is collected through AdWords Remarketing. AdWords Remarketing is a Remarketing and Behavioral Targeting service provided by Google. It connects the activity of 1400tower.com with the Adwords advertising network and the Doubleclick Cookie. <a href=\"https://www.google.com/settings/ads/onweb#display_optout\">You can opt out of the cookie tracking here.</a></p><h2>How We Use Your Information</h2><p><strong>Personal Information</strong> We use the personal information that you submit to help enhance and personalize your use of our website. This information also allows us to provide you with relevant information, content, and advertising (on our website, in newsletters, via e-mail, etc.).</p><p>When you respond to an offer of information or a service on our website (for example, by completing an online form), we may use that information to connect you to a specific provider or with a trusted partner who will provide the information or service that you requested.</p><p>We may also use your personal information to respond to your inquiries, send you service e-mails or follow-up with a phone call with important information regarding our website and related services, and to send you newsletters and offers.</p><p><strong>Non-Personal Information</strong> We use anonymous and aggregated data to create statistics and reports for various business purposes. We may aggregate anonymous data and share it with our advertisers or partners in order to offer you potentially desirable content, products, and services.</p><p>The website usage information we collect is used to monitor and improve the operation, technical functions, and quality of our website and services. This data is also used to deliver customized content and advertising to you when your online behavior indicates that you are interested in a particular subject area.</p><p><strong>Disclosure of Data</strong> We do not disclose your personal information to third parties except under certain circumstances. Set forth below are various circumstances under which we may disclose your personal information:</p><ul><li>Certain employees of ours and independent contractors we work with have access to your personally identifiable information for the sole purpose of helping us run our business. These employees and contractors have confidentiality and security obligations.</li>\n<li>We may disclose your information to third parties who provide services, such as (but not limited to): contact information verification, payment processing, customer service, website hosting, and email delivery services.</li>\n<li>We may disclose your information to another business entity should we plan to merge with or be acquired by that business entity; or to any organization involved in a merger, transfer, or sale of our assets or business.</li>\n<li>We may also disclose your personally identifiable information to respond to law enforcement requests, court orders, or other legal processes; or if we believe that such disclosure is necessary to investigate, prevent, or respond to illegal activities, fraud, physical threats to you, others, or to yourself; or as otherwise required by any applicable law or regulation.</li>\n</ul><p>Before we disclose your personally identifiable information for other reasons, we will first obtain your consent, via e-mail, click-through, an online opportunity to enter your preference, or some other manner.</p><p>In the event that we disclose your personally identifiable information in accordance with this section (\"Disclosure of Data\"), we will require third parties to take appropriate measures to protect and maintain the privacy and confidentiality of your personally identifiable information.</p><p><strong>Prohibited Disclosures</strong> Except as set forth above, we will not disclose your personally identifiable information to any third party without your explicit consent. In addition, we will not sell, rent, or otherwise disclose our e-mail list or address list except as explicitly set forth in this Statement.</p><h2>Control of Your Personal Information</h2><p>Our customers may choose whether to provide personally identifiable information at the time of collection. In addition, customers may stop the delivery of future e-mail communications by unsubscribing at any time. For instance, each e-mail you receive (aside from \"service e-mails\") contains instructions explaining how to stop receiving such e-mails.</p><p>If your personally identifiable information (such as zip code, phone, or e-mail or postal address) changes, or if you no longer desire our service, we provide a way for you to correct, update, or delete/deactivate your personally identifiable information.</p><h2>Protection of Information—Security</h2><p>We are committed to the protection of your personal information. We use a variety of security technologies and procedures to help protect your personal information from unauthorized access, use, or disclosure.</p><p>You should keep in mind that no Internet communication is ever completely secure or error-free.</p><h2>Changes to This Statement</h2><p>We may periodically update this Statement to reflect changes in our services and policies. When we post changes to this Statement, we will revise the \"last updated\" date at the top of this Statement. If there are material changes to the Statement or in how we will use your personal information, we will notify you either by posting a prominent notice prior to implementing the change or by sending you a direct notification. We encourage you to periodically review this Statement to be informed of how we are protecting your information.</p><h2>Contact Information</h2><p>If you have questions or complaints regarding this Statement, you should contact us at</p><p>1400 Tower<br> 1400 West Riverside Ave<br> Spokane, WA 99201<br> United States</p><p>+1 (509) 555-1234</p>',NULL,NULL,0,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,11,2),(16,'RedirectorPage','2016-10-24 16:38:57','2016-08-25 16:36:48','privacy-policy-2','Privacy Policy',NULL,NULL,NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,3,13);
/*!40000 ALTER TABLE `SiteTree_Live` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteTree_ViewerGroups`
--

DROP TABLE IF EXISTS `SiteTree_ViewerGroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteTree_ViewerGroups` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `SiteTreeID` int(11) NOT NULL DEFAULT '0',
  `GroupID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `SiteTreeID` (`SiteTreeID`),
  KEY `GroupID` (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteTree_ViewerGroups`
--

LOCK TABLES `SiteTree_ViewerGroups` WRITE;
/*!40000 ALTER TABLE `SiteTree_ViewerGroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `SiteTree_ViewerGroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `SiteTree_versions`
--

DROP TABLE IF EXISTS `SiteTree_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `SiteTree_versions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RecordID` int(11) NOT NULL DEFAULT '0',
  `Version` int(11) NOT NULL DEFAULT '0',
  `WasPublished` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `AuthorID` int(11) NOT NULL DEFAULT '0',
  `PublisherID` int(11) NOT NULL DEFAULT '0',
  `ClassName` enum('SiteTree','Page','BioHolderPage','BioPage','HomePage','ErrorPage','RedirectorPage','VirtualPage','PlaceHolderPage') DEFAULT 'SiteTree',
  `LastEdited` datetime DEFAULT NULL,
  `Created` datetime DEFAULT NULL,
  `URLSegment` varchar(255) DEFAULT NULL,
  `Title` varchar(255) DEFAULT NULL,
  `MenuTitle` varchar(100) DEFAULT NULL,
  `Content` mediumtext,
  `MetaDescription` mediumtext,
  `ExtraMeta` mediumtext,
  `ShowInMenus` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ShowInSearch` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `Sort` int(11) NOT NULL DEFAULT '0',
  `HasBrokenFile` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `HasBrokenLink` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ReportClass` varchar(50) DEFAULT NULL,
  `CanViewType` enum('Anyone','LoggedInUsers','OnlyTheseUsers','Inherit') DEFAULT 'Inherit',
  `CanEditType` enum('LoggedInUsers','OnlyTheseUsers','Inherit') DEFAULT 'Inherit',
  `Priority` varchar(5) DEFAULT NULL,
  `MetaTitle` varchar(255) DEFAULT NULL,
  `ParentID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `RecordID_Version` (`RecordID`,`Version`),
  KEY `RecordID` (`RecordID`),
  KEY `Version` (`Version`),
  KEY `AuthorID` (`AuthorID`),
  KEY `PublisherID` (`PublisherID`),
  KEY `ParentID` (`ParentID`),
  KEY `URLSegment` (`URLSegment`),
  KEY `ClassName` (`ClassName`),
  FULLTEXT KEY `SearchFields` (`Title`,`MenuTitle`,`Content`,`MetaDescription`)
) ENGINE=MyISAM AUTO_INCREMENT=132 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `SiteTree_versions`
--

LOCK TABLES `SiteTree_versions` WRITE;
/*!40000 ALTER TABLE `SiteTree_versions` DISABLE KEYS */;
INSERT INTO `SiteTree_versions` (`ID`, `RecordID`, `Version`, `WasPublished`, `AuthorID`, `PublisherID`, `ClassName`, `LastEdited`, `Created`, `URLSegment`, `Title`, `MenuTitle`, `Content`, `MetaDescription`, `ExtraMeta`, `ShowInMenus`, `ShowInSearch`, `Sort`, `HasBrokenFile`, `HasBrokenLink`, `ReportClass`, `CanViewType`, `CanEditType`, `Priority`, `MetaTitle`, `ParentID`) VALUES (1,1,1,1,0,0,'Page','2016-08-25 15:13:19','2016-08-25 15:13:19','home','Home',NULL,'<p>Welcome to SilverStripe! This is the default homepage. You can edit this page by opening <a href=\"admin/\">the CMS</a>.</p><p>You can now access the <a href=\"http://docs.silverstripe.org\">developer documentation</a>, or begin the <a href=\"http://www.silverstripe.org/learn/lessons\">SilverStripe lessons</a>.</p>',NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(2,2,1,1,0,0,'Page','2016-08-25 15:13:19','2016-08-25 15:13:19','about-us','About Us',NULL,'<p>You can fill this page out with your own content, or delete it and create your own pages.<br></p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(3,3,1,1,0,0,'Page','2016-08-25 15:13:19','2016-08-25 15:13:19','contact-us','Contact Us',NULL,'<p>You can fill this page out with your own content, or delete it and create your own pages.<br></p>',NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(4,4,1,1,0,0,'ErrorPage','2016-08-25 15:13:19','2016-08-25 15:13:19','page-not-found','Page not found',NULL,'<p>Sorry, it seems you were trying to access a page that doesn\'t exist.</p><p>Please check the spelling of the URL you were trying to access and try again.</p>',NULL,NULL,0,0,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(5,5,1,1,0,0,'ErrorPage','2016-08-25 15:13:19','2016-08-25 15:13:19','server-error','Server error',NULL,'<p>Sorry, there was a problem with handling your request.</p>',NULL,NULL,0,0,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(6,6,1,0,1,0,'Page','2016-08-25 16:27:38','2016-08-25 16:27:38','new-page','New Page',NULL,NULL,NULL,NULL,1,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(7,6,2,1,1,1,'Page','2016-08-25 16:27:47','2016-08-25 16:27:38','locationmap','Location/Map',NULL,NULL,NULL,NULL,1,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(8,7,1,0,1,0,'Page','2016-08-25 16:27:59','2016-08-25 16:27:59','new-page','New Page',NULL,NULL,NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(9,7,2,1,1,1,'Page','2016-08-25 16:28:08','2016-08-25 16:27:59','bio-1','Bio 1',NULL,NULL,NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(10,8,1,0,1,0,'Page','2016-08-25 16:28:14','2016-08-25 16:28:14','new-page','New Page',NULL,NULL,NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(11,8,2,1,1,1,'Page','2016-08-25 16:28:21','2016-08-25 16:28:14','bio-2','Bio 2',NULL,NULL,NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(12,9,1,0,1,0,'Page','2016-08-25 16:28:27','2016-08-25 16:28:27','new-page','New Page',NULL,NULL,NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(13,9,2,1,1,1,'Page','2016-08-25 16:28:34','2016-08-25 16:28:27','bio-3','Bio 3',NULL,NULL,NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(14,10,1,0,1,0,'Page','2016-08-25 16:28:46','2016-08-25 16:28:46','new-page','New Page',NULL,NULL,NULL,NULL,1,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(15,10,2,1,1,1,'Page','2016-08-25 16:28:52','2016-08-25 16:28:46','bio-4','Bio 4',NULL,NULL,NULL,NULL,1,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(16,11,1,0,1,0,'Page','2016-08-25 16:29:02','2016-08-25 16:29:02','new-page','New Page',NULL,NULL,NULL,NULL,1,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(17,11,2,1,1,1,'Page','2016-08-25 16:29:09','2016-08-25 16:29:02','bio-5','Bio 5',NULL,NULL,NULL,NULL,1,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(18,12,1,0,1,0,'Page','2016-08-25 16:29:21','2016-08-25 16:29:21','new-page','New Page',NULL,NULL,NULL,NULL,1,1,7,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(19,12,2,1,1,1,'Page','2016-08-25 16:29:39','2016-08-25 16:29:21','video-component','Video Component',NULL,NULL,NULL,NULL,1,1,7,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(20,6,3,1,1,1,'Page','2016-08-25 16:29:45','2016-08-25 16:27:38','locationmap','Location/Map',NULL,NULL,NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(21,12,3,1,1,1,'Page','2016-08-25 16:29:48','2016-08-25 16:29:21','video-component','Video Component',NULL,NULL,NULL,NULL,1,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(22,13,1,0,1,0,'PlaceHolderPage','2016-08-25 16:35:05','2016-08-25 16:35:05','new-place-holder-page','New Place Holder Page',NULL,NULL,NULL,NULL,1,0,8,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(23,13,2,1,1,1,'PlaceHolderPage','2016-08-25 16:35:13','2016-08-25 16:35:05','footer-links','Footer Links',NULL,NULL,NULL,NULL,1,0,8,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(24,14,1,0,1,0,'Page','2016-08-25 16:35:21','2016-08-25 16:35:21','new-page','New Page',NULL,NULL,NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,13),(25,14,2,1,1,1,'Page','2016-08-25 16:35:35','2016-08-25 16:35:21','private-section','Private Section ',NULL,NULL,NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,13),(26,13,3,1,1,1,'PlaceHolderPage','2016-08-25 16:35:44','2016-08-25 16:35:05','footer-links','Footer Links',NULL,NULL,NULL,NULL,0,0,8,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(27,15,1,0,1,0,'Page','2016-08-25 16:36:05','2016-08-25 16:36:05','new-page','New Page',NULL,NULL,NULL,NULL,1,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(28,15,2,1,1,1,'Page','2016-08-25 16:36:16','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,NULL,NULL,NULL,1,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(29,15,3,1,1,1,'Page','2016-08-25 16:36:22','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,NULL,NULL,NULL,0,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(30,1,2,1,1,1,'HomePage','2016-08-25 16:36:35','2016-08-25 15:13:19','home','Home',NULL,'<p>Welcome to SilverStripe! This is the default homepage. You can edit this page by opening <a href=\"admin/\">the CMS</a>.</p><p>You can now access the <a href=\"http://docs.silverstripe.org\">developer documentation</a>, or begin the <a href=\"http://www.silverstripe.org/learn/lessons\">SilverStripe lessons</a>.</p>',NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(31,16,1,0,1,0,'RedirectorPage','2016-08-25 16:36:48','2016-08-25 16:36:48','new-redirector-page','New Redirector Page',NULL,NULL,NULL,NULL,1,1,2,0,1,NULL,'Inherit','Inherit',NULL,NULL,13),(32,16,2,1,1,1,'RedirectorPage','2016-08-25 16:36:57','2016-08-25 16:36:48','new-redirector-page','New Redirector Page',NULL,NULL,NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,13),(33,1,3,1,1,1,'HomePage','2016-08-25 16:39:23','2016-08-25 15:13:19','home','Home',NULL,'<p>Welcome to SilverStripe! This is the default homepage. You can edit this page by opening <a href=\"admin/\">the CMS</a>.</p><p>You can now access the <a href=\"http://docs.silverstripe.org\">developer documentation</a>, or begin the <a href=\"http://www.silverstripe.org/learn/lessons\">SilverStripe lessons</a>.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(34,2,2,1,1,1,'Page','2016-09-07 13:30:32','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>You can fill this page out with your own content, or delete it and create your own pages.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(35,15,4,0,1,0,'Page','2016-09-07 13:31:05','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,NULL,NULL,NULL,0,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,13),(36,15,5,1,1,1,'Page','2016-09-07 13:31:05','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,NULL,NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,13),(37,2,3,1,2,2,'Page','2016-09-13 10:57:48','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better.  1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown.</p><p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants or enjoying the city’s first class entertainment venues.  1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.”   Amenities will also include secure covered parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all unites. </p><p>Be a part of 1400 Tower and enjoy life at the region’s most luxurious address.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(38,7,3,1,2,2,'Page','2016-09-13 11:01:11','2016-08-25 16:27:59','bio-1','Bio 1',NULL,'<p>1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.</p><p>Mick McDowell</p><p>Mick McDowell is a highly experienced and well qualified developer, builder and community leader.  Over the past 30 years, Mick has purchased, modernized and restored 28 buildings in downtown Spokane all of which continue to successfully operate today.  His landmark project is the five story Banner Bank building near the Division Street gateway in downtown. In addition, Mick sits on the Spokane Public Facility District Board of Directors and chairs the Project Committee which oversaw the recently completed multi-million dollar Spokane Convention Center expansion effort.  He also served as chair of the Downtown Spokane Partnership.  Mick began his developer’s career while working as a full-time firefighter with the Spokane Fire Department and served 20 years with distinction before retiring to concentrate on his other interests.</p>',NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(39,8,3,1,2,2,'Page','2016-09-13 11:01:42','2016-08-25 16:28:14','bio-2','Bio 2',NULL,'<p>Shelley McDowell</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(40,9,3,1,2,2,'Page','2016-09-13 11:02:39','2016-08-25 16:28:27','bio-3','Bio 3',NULL,'<p>Anton C. DeLateur</p><p>Anton DeLateur is a Spokane businessman and Financial Advisor and a long-time supporter of various business, educational and charitable interests in Spokane.  He brings over 36 years of experience in finance and organization to our enterprise.   Anton earned a BA in Philosophy and Classical languages from St. Thomas in Seattle in 1967 and a Licentiate in Philosophy from Gonzaga University.  He also taught Classical languages and Music at Gonzaga Prep and JFK Memorial High School in Seattle from 1969 to 1979 before joining the financial world.  He has served on the board of Morningstar Boys Ranch, is advisor to St. Joseph’s Family Center, and has been an ardent supporter of local music and marching band organizations. </p>',NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(41,10,3,1,2,2,'Page','2016-09-13 11:03:15','2016-08-25 16:28:46','bio-4','Bio 4',NULL,'<p>Donald Howell</p><p>Donald Howell has been involved in a broad spectrum of highly varied real estate and business related activities spanning an almost 40 career of corporate and personal business enterprises.  Don’s successful efforts include a 31-year management position career with a national title and escrow company, numerous private property investment opportunities including acquisition and operating a private equity financing company, a manufacturing company commercial property acquisition and renovation, and residential home construction enterprises. </p>',NULL,NULL,1,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(42,11,3,1,2,2,'Page','2016-09-13 11:08:11','2016-08-25 16:29:02','bio-5','Bio 5',NULL,'<p>Tobby Hatley</p><p>Tobby Hatley has more than 30 years of media and public affairs experience having worked in TV, radio print, politics and marketing. He is 1400 Tower\'s communications manager.</p><p>Tobby began his career in 1978 in broadcast sales after earning a BA in Radio and TV Management from Eastern Washington University. Tobby learned the ins and outs of politics, legislative issues and public affairs while covering state and local governments in Washington, Idaho and Montana as well as the U.S. Congress in Washington, D.C.  Tobby became most familiar to Inland Northwest residents as a broadcast journalist during his 14 years with KHQ-TV in Spokane.  </p><p>Tobby has a Master’s degree in Communications with an emphasis in Journalism and Public Affairs from The American University in Washington, D.C. </p><p> </p><p> </p>',NULL,NULL,1,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(43,6,4,1,2,2,'Page','2016-09-13 11:08:28','2016-08-25 16:27:38','locationmap','Location/Map',NULL,'<p>1400 West Riverside Avenue</p>',NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(44,3,2,1,2,2,'Page','2016-09-13 11:10:35','2016-08-25 15:13:19','contact-us','Contact Us',NULL,'<p>For more information about 1400 Tower please contact us at:</p><p>info@1400tower.com  or (Phone number?) </p>',NULL,NULL,1,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(45,2,4,1,2,2,'Page','2016-09-14 11:10:53','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants or enjoying the city’s first class entertainment venues.  1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.”   Amenities will also include secure covered parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all unites. </p><p>Be a part of 1400 Tower and enjoy life at the region’s most luxurious address.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(46,1,4,0,2,0,'HomePage','2016-09-14 11:11:12','2016-08-25 15:13:19','home','Home',NULL,'<p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(47,2,5,1,2,2,'Page','2016-09-14 11:11:26','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants or enjoying the city’s first class entertainment venues.  1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.”   Amenities will also include secure covered parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all unites. </p><p> </p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(48,1,5,1,2,2,'HomePage','2016-09-14 11:11:38','2016-08-25 15:13:19','home','Home',NULL,'<p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown.  </p><p>Be a part of 1400 Tower and enjoy life at the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(49,1,6,1,2,2,'HomePage','2016-09-14 11:12:16','2016-08-25 15:13:19','home','Home',NULL,'<p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(50,8,4,1,2,2,'Page','2016-09-20 13:09:15','2016-08-25 16:28:14','bio-2','Bio 2',NULL,'<p>Shelley McDowell</p><p>Shelley McDowell is a licensed Real Estate Managing Broker, developer and former investment advisor.   A life-long Spokane resident, Shelley holds a Bachelor of Science in Business Administration from U. of the State of NY, Albany and is currently the Branch Manager for Century 21 Beutler &amp; Associates Spokane office.  Shelley spent 10 years as an investment advisor before deciding to help her husband Mick develop almost 30 downtown Spokane projects and manage 250 apartment units.  Shelley continues to help Mick own and operate downtown’s Banner Bank building. </p><p>Shelley’s also very community minded.  She’s a YMCA board member, past board member and Chair of the Spokane Club, Past President and board member of EWI of Spokane and currently sits on the Riverbank Board of Directors.</p><p>Summers find Shelley enjoying mountain biking, boating, swimming and hiking.   She spends the cooler weather in spinning classes, sitting by cozy fires and sipping fine wine. </p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(51,15,6,0,1,0,'Page','2016-10-19 17:04:11','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,NULL,NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(52,15,7,1,1,1,'Page','2016-10-19 17:04:11','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,NULL,NULL,NULL,0,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(53,14,3,0,1,0,'Page','2016-10-19 17:04:17','2016-08-25 16:35:21','private-section','Private Section ',NULL,NULL,NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(54,14,4,0,1,0,'Page','2016-10-19 17:04:17','2016-08-25 16:35:21','private-section','Private Section ',NULL,NULL,NULL,NULL,1,1,7,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(55,16,3,1,1,1,'RedirectorPage','2016-10-19 17:04:27','2016-08-25 16:36:48','privacy-policy','Privacy Policy',NULL,NULL,NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,13),(56,13,4,1,1,1,'PlaceHolderPage','2016-10-19 17:04:58','2016-08-25 16:35:05','footer-links','Footer Links',NULL,NULL,NULL,NULL,0,0,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(57,7,4,1,1,1,'Page','2016-10-19 17:05:25','2016-08-25 16:27:59','mick-mcdowell','Mick McDowell',NULL,'<p>1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.</p><p>Mick McDowell</p><p>Mick McDowell is a highly experienced and well qualified developer, builder and community leader.  Over the past 30 years, Mick has purchased, modernized and restored 28 buildings in downtown Spokane all of which continue to successfully operate today.  His landmark project is the five story Banner Bank building near the Division Street gateway in downtown. In addition, Mick sits on the Spokane Public Facility District Board of Directors and chairs the Project Committee which oversaw the recently completed multi-million dollar Spokane Convention Center expansion effort.  He also served as chair of the Downtown Spokane Partnership.  Mick began his developer’s career while working as a full-time firefighter with the Spokane Fire Department and served 20 years with distinction before retiring to concentrate on his other interests.</p>',NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(58,8,5,1,1,1,'Page','2016-10-19 17:05:41','2016-08-25 16:28:14','shelley-mcdowell','Shelley McDowell',NULL,'<p>Shelley McDowell</p><p>Shelley McDowell is a licensed Real Estate Managing Broker, developer and former investment advisor.   A life-long Spokane resident, Shelley holds a Bachelor of Science in Business Administration from U. of the State of NY, Albany and is currently the Branch Manager for Century 21 Beutler &amp; Associates Spokane office.  Shelley spent 10 years as an investment advisor before deciding to help her husband Mick develop almost 30 downtown Spokane projects and manage 250 apartment units.  Shelley continues to help Mick own and operate downtown’s Banner Bank building. </p><p>Shelley’s also very community minded.  She’s a YMCA board member, past board member and Chair of the Spokane Club, Past President and board member of EWI of Spokane and currently sits on the Riverbank Board of Directors.</p><p>Summers find Shelley enjoying mountain biking, boating, swimming and hiking.   She spends the cooler weather in spinning classes, sitting by cozy fires and sipping fine wine. </p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(59,7,5,1,1,1,'Page','2016-10-19 17:05:57','2016-08-25 16:27:59','mick-mcdowell','Mick McDowell',NULL,'<p>Mick McDowell is a highly experienced and well qualified developer, builder and community leader.  Over the past 30 years, Mick has purchased, modernized and restored 28 buildings in downtown Spokane all of which continue to successfully operate today.  His landmark project is the five story Banner Bank building near the Division Street gateway in downtown. In addition, Mick sits on the Spokane Public Facility District Board of Directors and chairs the Project Committee which oversaw the recently completed multi-million dollar Spokane Convention Center expansion effort.  He also served as chair of the Downtown Spokane Partnership.  Mick began his developer’s career while working as a full-time firefighter with the Spokane Fire Department and served 20 years with distinction before retiring to concentrate on his other interests.</p>',NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(60,2,6,1,1,1,'Page','2016-10-19 17:06:14','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants or enjoying the city’s first class entertainment venues.  1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.”   Amenities will also include secure covered parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all unites. </p><h2>1400 Principals</h2><p>1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(61,9,4,1,1,1,'Page','2016-10-19 17:06:27','2016-08-25 16:28:27','anton-c-delateur','Anton C. DeLateur',NULL,'<p>Anton DeLateur is a Spokane businessman and Financial Advisor and a long-time supporter of various business, educational and charitable interests in Spokane.  He brings over 36 years of experience in finance and organization to our enterprise.   Anton earned a BA in Philosophy and Classical languages from St. Thomas in Seattle in 1967 and a Licentiate in Philosophy from Gonzaga University.  He also taught Classical languages and Music at Gonzaga Prep and JFK Memorial High School in Seattle from 1969 to 1979 before joining the financial world.  He has served on the board of Morningstar Boys Ranch, is advisor to St. Joseph’s Family Center, and has been an ardent supporter of local music and marching band organizations. </p>',NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(62,10,4,1,1,1,'Page','2016-10-19 17:06:42','2016-08-25 16:28:46','donald-howell','Donald Howell',NULL,'<p>Donald Howell has been involved in a broad spectrum of highly varied real estate and business related activities spanning an almost 40 career of corporate and personal business enterprises.  Don’s successful efforts include a 31-year management position career with a national title and escrow company, numerous private property investment opportunities including acquisition and operating a private equity financing company, a manufacturing company commercial property acquisition and renovation, and residential home construction enterprises. </p>',NULL,NULL,1,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(63,11,4,1,1,1,'Page','2016-10-19 17:06:55','2016-08-25 16:29:02','tobby-hatley','Tobby Hatley',NULL,'<p>Tobby Hatley has more than 30 years of media and public affairs experience having worked in TV, radio print, politics and marketing. He is 1400 Tower\'s communications manager.</p><p>Tobby began his career in 1978 in broadcast sales after earning a BA in Radio and TV Management from Eastern Washington University. Tobby learned the ins and outs of politics, legislative issues and public affairs while covering state and local governments in Washington, Idaho and Montana as well as the U.S. Congress in Washington, D.C.  Tobby became most familiar to Inland Northwest residents as a broadcast journalist during his 14 years with KHQ-TV in Spokane.  </p><p>Tobby has a Master’s degree in Communications with an emphasis in Journalism and Public Affairs from The American University in Washington, D.C. </p><p> </p><p> </p>',NULL,NULL,1,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(64,2,7,1,1,1,'BioHolderPage','2016-10-19 17:12:29','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants or enjoying the city’s first class entertainment venues.  1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.”   Amenities will also include secure covered parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all unites. </p><h2>1400 Principals</h2><p>1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(65,7,6,1,1,1,'BioPage','2016-10-19 17:12:37','2016-08-25 16:27:59','mick-mcdowell','Mick McDowell',NULL,'<p>Mick McDowell is a highly experienced and well qualified developer, builder and community leader.  Over the past 30 years, Mick has purchased, modernized and restored 28 buildings in downtown Spokane all of which continue to successfully operate today.  His landmark project is the five story Banner Bank building near the Division Street gateway in downtown. In addition, Mick sits on the Spokane Public Facility District Board of Directors and chairs the Project Committee which oversaw the recently completed multi-million dollar Spokane Convention Center expansion effort.  He also served as chair of the Downtown Spokane Partnership.  Mick began his developer’s career while working as a full-time firefighter with the Spokane Fire Department and served 20 years with distinction before retiring to concentrate on his other interests.</p>',NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(66,8,6,1,1,1,'BioPage','2016-10-19 17:12:45','2016-08-25 16:28:14','shelley-mcdowell','Shelley McDowell',NULL,'<p>Shelley McDowell</p><p>Shelley McDowell is a licensed Real Estate Managing Broker, developer and former investment advisor.   A life-long Spokane resident, Shelley holds a Bachelor of Science in Business Administration from U. of the State of NY, Albany and is currently the Branch Manager for Century 21 Beutler &amp; Associates Spokane office.  Shelley spent 10 years as an investment advisor before deciding to help her husband Mick develop almost 30 downtown Spokane projects and manage 250 apartment units.  Shelley continues to help Mick own and operate downtown’s Banner Bank building. </p><p>Shelley’s also very community minded.  She’s a YMCA board member, past board member and Chair of the Spokane Club, Past President and board member of EWI of Spokane and currently sits on the Riverbank Board of Directors.</p><p>Summers find Shelley enjoying mountain biking, boating, swimming and hiking.   She spends the cooler weather in spinning classes, sitting by cozy fires and sipping fine wine. </p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(67,9,5,1,1,1,'BioPage','2016-10-19 17:12:55','2016-08-25 16:28:27','anton-c-delateur','Anton C. DeLateur',NULL,'<p>Anton DeLateur is a Spokane businessman and Financial Advisor and a long-time supporter of various business, educational and charitable interests in Spokane.  He brings over 36 years of experience in finance and organization to our enterprise.   Anton earned a BA in Philosophy and Classical languages from St. Thomas in Seattle in 1967 and a Licentiate in Philosophy from Gonzaga University.  He also taught Classical languages and Music at Gonzaga Prep and JFK Memorial High School in Seattle from 1969 to 1979 before joining the financial world.  He has served on the board of Morningstar Boys Ranch, is advisor to St. Joseph’s Family Center, and has been an ardent supporter of local music and marching band organizations. </p>',NULL,NULL,1,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(68,10,5,1,1,1,'BioPage','2016-10-19 17:13:03','2016-08-25 16:28:46','donald-howell','Donald Howell',NULL,'<p>Donald Howell has been involved in a broad spectrum of highly varied real estate and business related activities spanning an almost 40 career of corporate and personal business enterprises.  Don’s successful efforts include a 31-year management position career with a national title and escrow company, numerous private property investment opportunities including acquisition and operating a private equity financing company, a manufacturing company commercial property acquisition and renovation, and residential home construction enterprises. </p>',NULL,NULL,1,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(69,11,5,1,1,1,'BioPage','2016-10-19 17:13:14','2016-08-25 16:29:02','tobby-hatley','Tobby Hatley',NULL,'<p>Tobby Hatley has more than 30 years of media and public affairs experience having worked in TV, radio print, politics and marketing. He is 1400 Tower\'s communications manager.</p><p>Tobby began his career in 1978 in broadcast sales after earning a BA in Radio and TV Management from Eastern Washington University. Tobby learned the ins and outs of politics, legislative issues and public affairs while covering state and local governments in Washington, Idaho and Montana as well as the U.S. Congress in Washington, D.C.  Tobby became most familiar to Inland Northwest residents as a broadcast journalist during his 14 years with KHQ-TV in Spokane.  </p><p>Tobby has a Master’s degree in Communications with an emphasis in Journalism and Public Affairs from The American University in Washington, D.C. </p><p> </p><p> </p>',NULL,NULL,1,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(70,1,7,1,1,1,'HomePage','2016-10-20 09:25:46','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(71,1,8,1,1,1,'HomePage','2016-10-20 10:12:20','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(72,1,9,1,1,1,'HomePage','2016-10-20 10:38:05','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(73,1,10,1,1,1,'HomePage','2016-10-20 11:18:17','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(74,1,11,1,1,1,'HomePage','2016-10-20 12:14:39','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(75,17,1,1,1,1,'Page','2016-10-20 15:41:41','2016-10-20 15:41:41','new-page','New Page',NULL,NULL,NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,7),(76,18,1,1,1,1,'Page','2016-10-20 15:41:46','2016-10-20 15:41:46','new-page-2','New Page',NULL,NULL,NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,7),(77,19,1,1,1,1,'Page','2016-10-20 15:44:03','2016-10-20 15:44:03','new-page','New Page',NULL,NULL,NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,17),(78,20,1,0,1,0,'Page','2016-10-20 15:44:08','2016-10-20 15:44:08','new-page-2','New Page',NULL,NULL,NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,17),(79,17,2,1,1,1,'Page','2016-10-20 15:44:25','2016-10-20 15:41:41','new-long-name-page','New Long Name Page',NULL,NULL,NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,7),(80,20,2,1,1,1,'Page','2016-10-20 15:44:37','2016-10-20 15:44:08','new-long-name-page','New Long Name Page',NULL,NULL,NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,17),(81,7,7,1,1,1,'BioPage','2016-10-20 16:32:56','2016-08-25 16:27:59','mick-mcdowell','Mick McDowell',NULL,'<p>Mick McDowell is a highly experienced and well qualified developer, builder and community leader.  Over the past 30 years, Mick has purchased, modernized and restored 28 buildings in downtown Spokane all of which continue to successfully operate today.  His landmark project is the five story Banner Bank building near the Division Street gateway in downtown. In addition, Mick sits on the Spokane Public Facility District Board of Directors and chairs the Project Committee which oversaw the recently completed multi-million dollar Spokane Convention Center expansion effort.  He also served as chair of the Downtown Spokane Partnership.  Mick began his developer’s career while working as a full-time firefighter with the Spokane Fire Department and served 20 years with distinction before retiring to concentrate on his other interests.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(82,8,7,1,1,1,'BioPage','2016-10-20 16:33:07','2016-08-25 16:28:14','shelley-mcdowell','Shelley McDowell',NULL,'<p>Shelley McDowell</p><p>Shelley McDowell is a licensed Real Estate Managing Broker, developer and former investment advisor.   A life-long Spokane resident, Shelley holds a Bachelor of Science in Business Administration from U. of the State of NY, Albany and is currently the Branch Manager for Century 21 Beutler &amp; Associates Spokane office.  Shelley spent 10 years as an investment advisor before deciding to help her husband Mick develop almost 30 downtown Spokane projects and manage 250 apartment units.  Shelley continues to help Mick own and operate downtown’s Banner Bank building. </p><p>Shelley’s also very community minded.  She’s a YMCA board member, past board member and Chair of the Spokane Club, Past President and board member of EWI of Spokane and currently sits on the Riverbank Board of Directors.</p><p>Summers find Shelley enjoying mountain biking, boating, swimming and hiking.   She spends the cooler weather in spinning classes, sitting by cozy fires and sipping fine wine. </p>',NULL,NULL,0,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(83,9,6,1,1,1,'BioPage','2016-10-20 16:33:14','2016-08-25 16:28:27','anton-c-delateur','Anton C. DeLateur',NULL,'<p>Anton DeLateur is a Spokane businessman and Financial Advisor and a long-time supporter of various business, educational and charitable interests in Spokane.  He brings over 36 years of experience in finance and organization to our enterprise.   Anton earned a BA in Philosophy and Classical languages from St. Thomas in Seattle in 1967 and a Licentiate in Philosophy from Gonzaga University.  He also taught Classical languages and Music at Gonzaga Prep and JFK Memorial High School in Seattle from 1969 to 1979 before joining the financial world.  He has served on the board of Morningstar Boys Ranch, is advisor to St. Joseph’s Family Center, and has been an ardent supporter of local music and marching band organizations. </p>',NULL,NULL,0,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(84,10,6,1,1,1,'BioPage','2016-10-20 16:33:23','2016-08-25 16:28:46','donald-howell','Donald Howell',NULL,'<p>Donald Howell has been involved in a broad spectrum of highly varied real estate and business related activities spanning an almost 40 career of corporate and personal business enterprises.  Don’s successful efforts include a 31-year management position career with a national title and escrow company, numerous private property investment opportunities including acquisition and operating a private equity financing company, a manufacturing company commercial property acquisition and renovation, and residential home construction enterprises. </p>',NULL,NULL,0,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(85,11,6,1,1,1,'BioPage','2016-10-20 16:33:31','2016-08-25 16:29:02','tobby-hatley','Tobby Hatley',NULL,'<p>Tobby Hatley has more than 30 years of media and public affairs experience having worked in TV, radio print, politics and marketing. He is 1400 Tower\'s communications manager.</p><p>Tobby began his career in 1978 in broadcast sales after earning a BA in Radio and TV Management from Eastern Washington University. Tobby learned the ins and outs of politics, legislative issues and public affairs while covering state and local governments in Washington, Idaho and Montana as well as the U.S. Congress in Washington, D.C.  Tobby became most familiar to Inland Northwest residents as a broadcast journalist during his 14 years with KHQ-TV in Spokane.  </p><p>Tobby has a Master’s degree in Communications with an emphasis in Journalism and Public Affairs from The American University in Washington, D.C. </p><p> </p><p> </p>',NULL,NULL,0,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(86,7,8,1,1,1,'BioPage','2016-10-24 16:05:20','2016-08-25 16:27:59','mick-mcdowell','MICK McDOWELL',NULL,'<p>Mick McDowell is a highly experienced and well qualified developer, builder and community leader.  Over the past 30 years, Mick has purchased, modernized and restored 28 buildings in downtown Spokane all of which continue to successfully operate today.  His landmark project is the five story Banner Bank building near the Division Street gateway in downtown. In addition, Mick sits on the Spokane Public Facility District Board of Directors and chairs the Project Committee which oversaw the recently completed multi-million dollar Spokane Convention Center expansion effort.  He also served as chair of the Downtown Spokane Partnership.  Mick began his developer’s career while working as a full-time firefighter with the Spokane Fire Department and served 20 years with distinction before retiring to concentrate on his other interests.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(87,8,8,1,1,1,'BioPage','2016-10-24 16:05:33','2016-08-25 16:28:14','shelley-mcdowell','SHELLEY McDOWELL',NULL,'<p>Shelley McDowell</p><p>Shelley McDowell is a licensed Real Estate Managing Broker, developer and former investment advisor.   A life-long Spokane resident, Shelley holds a Bachelor of Science in Business Administration from U. of the State of NY, Albany and is currently the Branch Manager for Century 21 Beutler &amp; Associates Spokane office.  Shelley spent 10 years as an investment advisor before deciding to help her husband Mick develop almost 30 downtown Spokane projects and manage 250 apartment units.  Shelley continues to help Mick own and operate downtown’s Banner Bank building. </p><p>Shelley’s also very community minded.  She’s a YMCA board member, past board member and Chair of the Spokane Club, Past President and board member of EWI of Spokane and currently sits on the Riverbank Board of Directors.</p><p>Summers find Shelley enjoying mountain biking, boating, swimming and hiking.   She spends the cooler weather in spinning classes, sitting by cozy fires and sipping fine wine. </p>',NULL,NULL,0,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(88,9,7,1,1,1,'BioPage','2016-10-24 16:05:49','2016-08-25 16:28:27','anton-c-delateur','ANTON C. DeLATEUR',NULL,'<p>Anton DeLateur is a Spokane businessman and Financial Advisor and a long-time supporter of various business, educational and charitable interests in Spokane.  He brings over 36 years of experience in finance and organization to our enterprise.   Anton earned a BA in Philosophy and Classical languages from St. Thomas in Seattle in 1967 and a Licentiate in Philosophy from Gonzaga University.  He also taught Classical languages and Music at Gonzaga Prep and JFK Memorial High School in Seattle from 1969 to 1979 before joining the financial world.  He has served on the board of Morningstar Boys Ranch, is advisor to St. Joseph’s Family Center, and has been an ardent supporter of local music and marching band organizations. </p>',NULL,NULL,0,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(89,10,7,1,1,1,'BioPage','2016-10-24 16:06:00','2016-08-25 16:28:46','donald-howell','DONALD HOWELL',NULL,'<p>Donald Howell has been involved in a broad spectrum of highly varied real estate and business related activities spanning an almost 40 career of corporate and personal business enterprises.  Don’s successful efforts include a 31-year management position career with a national title and escrow company, numerous private property investment opportunities including acquisition and operating a private equity financing company, a manufacturing company commercial property acquisition and renovation, and residential home construction enterprises. </p>',NULL,NULL,0,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(90,11,7,1,1,1,'BioPage','2016-10-24 16:06:08','2016-08-25 16:29:02','tobby-hatley','TOBBY HATLEY',NULL,'<p>Tobby Hatley has more than 30 years of media and public affairs experience having worked in TV, radio print, politics and marketing. He is 1400 Tower\'s communications manager.</p><p>Tobby began his career in 1978 in broadcast sales after earning a BA in Radio and TV Management from Eastern Washington University. Tobby learned the ins and outs of politics, legislative issues and public affairs while covering state and local governments in Washington, Idaho and Montana as well as the U.S. Congress in Washington, D.C.  Tobby became most familiar to Inland Northwest residents as a broadcast journalist during his 14 years with KHQ-TV in Spokane.  </p><p>Tobby has a Master’s degree in Communications with an emphasis in Journalism and Public Affairs from The American University in Washington, D.C. </p><p> </p><p> </p>',NULL,NULL,0,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(91,7,9,1,1,1,'BioPage','2016-10-24 16:32:58','2016-08-25 16:27:59','mick-mcdowell','MICK McDOWELL',NULL,'<p>Mick McDowell is a highly experienced and well qualified developer, builder and community leader.  Over the past 30 years, Mick has purchased, modernized and restored 28 buildings in downtown Spokane all of which continue to successfully operate today.  His landmark project is the five story Banner Bank building near the Division Street gateway in downtown. In addition, Mick sits on the Spokane Public Facility District Board of Directors and chairs the Project Committee which oversaw the recently completed multi-million dollar Spokane Convention Center expansion effort.  He also served as chair of the Downtown Spokane Partnership.  Mick began his developer’s career while working as a full-time firefighter with the Spokane Fire Department and served 20 years with distinction before retiring to concentrate on his other interests.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(92,8,9,1,1,1,'BioPage','2016-10-24 16:33:05','2016-08-25 16:28:14','shelley-mcdowell','SHELLEY McDOWELL',NULL,'<p>Shelley McDowell</p><p>Shelley McDowell is a licensed Real Estate Managing Broker, developer and former investment advisor.   A life-long Spokane resident, Shelley holds a Bachelor of Science in Business Administration from U. of the State of NY, Albany and is currently the Branch Manager for Century 21 Beutler &amp; Associates Spokane office.  Shelley spent 10 years as an investment advisor before deciding to help her husband Mick develop almost 30 downtown Spokane projects and manage 250 apartment units.  Shelley continues to help Mick own and operate downtown’s Banner Bank building. </p><p>Shelley’s also very community minded.  She’s a YMCA board member, past board member and Chair of the Spokane Club, Past President and board member of EWI of Spokane and currently sits on the Riverbank Board of Directors.</p><p>Summers find Shelley enjoying mountain biking, boating, swimming and hiking.   She spends the cooler weather in spinning classes, sitting by cozy fires and sipping fine wine. </p>',NULL,NULL,0,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(93,9,8,1,1,1,'BioPage','2016-10-24 16:33:12','2016-08-25 16:28:27','anton-c-delateur','ANTON C. DeLATEUR',NULL,'<p>Anton DeLateur is a Spokane businessman and Financial Advisor and a long-time supporter of various business, educational and charitable interests in Spokane.  He brings over 36 years of experience in finance and organization to our enterprise.   Anton earned a BA in Philosophy and Classical languages from St. Thomas in Seattle in 1967 and a Licentiate in Philosophy from Gonzaga University.  He also taught Classical languages and Music at Gonzaga Prep and JFK Memorial High School in Seattle from 1969 to 1979 before joining the financial world.  He has served on the board of Morningstar Boys Ranch, is advisor to St. Joseph’s Family Center, and has been an ardent supporter of local music and marching band organizations. </p>',NULL,NULL,0,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(94,10,8,1,1,1,'BioPage','2016-10-24 16:33:18','2016-08-25 16:28:46','donald-howell','DONALD HOWELL',NULL,'<p>Donald Howell has been involved in a broad spectrum of highly varied real estate and business related activities spanning an almost 40 career of corporate and personal business enterprises.  Don’s successful efforts include a 31-year management position career with a national title and escrow company, numerous private property investment opportunities including acquisition and operating a private equity financing company, a manufacturing company commercial property acquisition and renovation, and residential home construction enterprises. </p>',NULL,NULL,0,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(95,11,8,1,1,1,'BioPage','2016-10-24 16:33:24','2016-08-25 16:29:02','tobby-hatley','TOBBY HATLEY',NULL,'<p>Tobby Hatley has more than 30 years of media and public affairs experience having worked in TV, radio print, politics and marketing. He is 1400 Tower\'s communications manager.</p><p>Tobby began his career in 1978 in broadcast sales after earning a BA in Radio and TV Management from Eastern Washington University. Tobby learned the ins and outs of politics, legislative issues and public affairs while covering state and local governments in Washington, Idaho and Montana as well as the U.S. Congress in Washington, D.C.  Tobby became most familiar to Inland Northwest residents as a broadcast journalist during his 14 years with KHQ-TV in Spokane.  </p><p>Tobby has a Master’s degree in Communications with an emphasis in Journalism and Public Affairs from The American University in Washington, D.C. </p><p> </p><p> </p>',NULL,NULL,0,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(96,15,8,1,1,1,'Page','2016-10-24 16:35:56','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,'<p>Last update: September 27, 2016</p><p>Your privacy is important to us. This privacy policy discusses how and why we collect information from you and what we do with it. This Privacy Policy applies to our website, pyrotek.com.</p><h2>Collection of Information</h2><p><strong>Personal Information</strong> You may submit to us personal information that identifies you as an individual when you choose to interact with us on this website. Personal information that you may submit includes your name, e-mail address, postal address and telephone number. In some cases, you may also submit demographic information such as your age, gender, zip code, level of education, household income, and interests. If we combine demographic information with your personal information, we will treat it as personal information as set forth in this Privacy Statement. In some cases, you may provide additional information including when you choose to personalize your use of our website for medical conditions of interest, when you ask a question of our experts, or when you contact our customer support group.</p><p><strong>Personal Information Provided When Requesting Information</strong> On this website you will find web forms where you are requested to submit personal information in order to be contacted by our Sales and/or Marketing Department. When you submit your personal information via such forms, we will make our best effort to protect your personal information in accordance with our privacy and information security policies.</p><p><strong>Children\'s Personal Information</strong> We do not knowingly collect personally identifiable information from users under the age of 13. If we find out that we have such personal information, we will take reasonable steps to delete it.</p><p><strong>Website Usage Information</strong> Our website collects non-personally identifiable information such as navigational data (log files, server logs, click-stream) and information about how our website is used by you (through cookies or web beacons, etc.). We may also collect information such as the URL of the website you previously visited and the time of day that you use our website. Analytics information also keeps track of the pages you visit within our website. You can set your browser to notify you when a cookie is sent, or to refuse or delete cookies altogether, but in such cases many features of our website will not function as designed. Additional information is collected through AdWords Remarketing. AdWords Remarketing is a Remarketing and Behavioral Targeting service provided by Google. It connects the activity of pyrotek.com with the Adwords advertising network and the Doubleclick Cookie. <a href=\"https://www.google.com/settings/ads/onweb#display_optout\">You can opt out of the cookie tracking here.</a></p><p><strong>International Users</strong> As an international company, Pyrotek, Inc. abides by Safe Harbor and Asia-Pacific Economic Cooperation (APEC) Frameworks to ensure consumer privacy and protection. As a part of the Safe Harbor Program, users from the European Union and Switzerland are provided personal data protection as specified by the European Commission. It is our priority to protect the flow of personal information across borders, so that our international users can use our website securely.</p><p>Pyrotek, Inc. stores any collected information within the United States; however, any information collected by Google is stored in accordance with Google’s <a href=\"http://cp.mcafee.com/d/1jWVIq40Ue6zqb3XbZS6bICXCQrCzBxNxAQszDzqdPhOMUMNtdMSyzss-MUqenQPqdPhOMUqehP1EVvdDS5fz2hk54WPFfoPVsSjHeAZzfBPq9EV744ZsvW_9EzCkmkuLsKCPtzC6nxOrbDbnhIyyGzt_BgY-F6lK1FJ4SMrLObPwWWarzPNKVIDeqR4IMFN6Ji9_YLyRjVmBZcmz8PJyS6Q9r3RgklfrwxcDmyLNVsS-CCqenzobZ8Qg1sc0Ao18w2Miq80j7okfSsGMd44v5C_FcSOCrKWLe-MNS\">Privacy Policy</a>. Learn more about the <a href=\"http://cp.mcafee.com/d/k-Kr6hESyM-O_txyX9KVJ6VEVosopd78VUSzsQsIeccnjsdEET7fIe6zBZcSzsQsIe6zAsMqenPpZxjUMAl1heIWjSc-ndAWPFfoPVsSyqehN1fn7-LOq8VB5B7HTbFIToVxBUsCOVORQr8EGETvVkffGhBrwqrjdI6XYyYUeKyCUYYrKr01u7HlzfydjekRTOuN8lzxJ2mMZk55jSU8j9REHYundLFFCzBUS2_id40n30960i80I4Cy04NS53ZDaI3h17NpLWjdIFCOVYl9Fo1K9fS\">Safe Harbor Frameworks</a>. </p><h2>How We Use Your Information</h2><p><strong>Personal Information</strong> We use the personal information that you submit to help enhance and personalize your use of our website. This information also allows us to provide you with relevant information, content, and advertising (on our website, in newsletters, via e-mail, etc.).</p><p>When you respond to an offer of information or a service on our website (for example, by completing an online form), we may use that information to connect you to a specific provider or with a trusted partner who will provide the information or service that you requested.</p><p>We may also use your personal information to respond to your inquiries, send you service e-mails or follow-up with a phone call with important information regarding our website and related services, and to send you newsletters and offers.</p><p><strong>Non-Personal Information</strong> We use anonymous and aggregated data to create statistics and reports for various business purposes. We may aggregate anonymous data and share it with our advertisers or partners in order to offer you potentially desirable content, products, and services.</p><p>The website usage information we collect is used to monitor and improve the operation, technical functions, and quality of our website and services. This data is also used to deliver customized content and advertising to you when your online behavior indicates that you are interested in a particular subject area.</p><p><strong>Disclosure of Data</strong> We do not disclose your personal information to third parties except under certain circumstances. Set forth below are various circumstances under which we may disclose your personal information:</p><ul><li>Certain employees of ours and independent contractors we work with have access to your personally identifiable information for the sole purpose of helping us run our business. These employees and contractors have confidentiality and security obligations.</li>\n<li>We may disclose your information to third parties who provide services, such as (but not limited to): contact information verification, payment processing, customer service, website hosting, and email delivery services.</li>\n<li>We may disclose your information to another business entity should we plan to merge with or be acquired by that business entity; or to any organization involved in a merger, transfer, or sale of our assets or business.</li>\n<li>We may also disclose your personally identifiable information to respond to law enforcement requests, court orders, or other legal processes; or if we believe that such disclosure is necessary to investigate, prevent, or respond to illegal activities, fraud, physical threats to you, others, or to yourself; or as otherwise required by any applicable law or regulation.</li>\n</ul><p>Before we disclose your personally identifiable information for other reasons, we will first obtain your consent, via e-mail, click-through, an online opportunity to enter your preference, or some other manner.</p><p>In the event that we disclose your personally identifiable information in accordance with this section (\"Disclosure of Data\"), we will require third parties to take appropriate measures to protect and maintain the privacy and confidentiality of your personally identifiable information.</p><p><strong>Prohibited Disclosures</strong> Except as set forth above, we will not disclose your personally identifiable information to any third party without your explicit consent. In addition, we will not sell, rent, or otherwise disclose our e-mail list or address list except as explicitly set forth in this Statement.</p><h2>Control of Your Personal Information</h2><p>Our customers may choose whether to provide personally identifiable information at the time of collection. In addition, customers may stop the delivery of future e-mail communications by unsubscribing at any time. For instance, each e-mail you receive (aside from \"service e-mails\") contains instructions explaining how to stop receiving such e-mails.</p><p>If your personally identifiable information (such as zip code, phone, or e-mail or postal address) changes, or if you no longer desire our service, we provide a way for you to correct, update, or delete/deactivate your personally identifiable information.</p><h2>Protection of Information—Security</h2><p>We are committed to the protection of your personal information. We use a variety of security technologies and procedures to help protect your personal information from unauthorized access, use, or disclosure.</p><p>You should keep in mind that no Internet communication is ever completely secure or error-free.</p><h2>Changes to This Statement</h2><p>We may periodically update this Statement to reflect changes in our services and policies. When we post changes to this Statement, we will revise the \"last updated\" date at the top of this Statement. If there are material changes to the Statement or in how we will use your personal information, we will notify you either by posting a prominent notice prior to implementing the change or by sending you a direct notification. We encourage you to periodically review this Statement to be informed of how we are protecting your information.</p><h2>Contact Information</h2><p>If you have questions or complaints regarding this Statement, you should contact us at</p><p>1400 Tower<br> 1400 West Riverside Ave<br> Spokane, WA 99201<br> United States</p><p>+1 (509) 555-1234</p>',NULL,NULL,0,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(97,15,9,1,1,1,'Page','2016-10-24 16:36:14','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,'<p>Last update: October 24, 2016</p><p>Your privacy is important to us. This privacy policy discusses how and why we collect information from you and what we do with it. This Privacy Policy applies to our website, 1400tower.com.</p><h2>Collection of Information</h2><p><strong>Personal Information</strong> You may submit to us personal information that identifies you as an individual when you choose to interact with us on this website. Personal information that you may submit includes your name, e-mail address, postal address and telephone number. In some cases, you may also submit demographic information such as your age, gender, zip code, level of education, household income, and interests. If we combine demographic information with your personal information, we will treat it as personal information as set forth in this Privacy Statement. In some cases, you may provide additional information including when you choose to personalize your use of our website for medical conditions of interest, when you ask a question of our experts, or when you contact our customer support group.</p><p><strong>Personal Information Provided When Requesting Information</strong> On this website you will find web forms where you are requested to submit personal information in order to be contacted by our Sales and/or Marketing Department. When you submit your personal information via such forms, we will make our best effort to protect your personal information in accordance with our privacy and information security policies.</p><p><strong>Children\'s Personal Information</strong> We do not knowingly collect personally identifiable information from users under the age of 13. If we find out that we have such personal information, we will take reasonable steps to delete it.</p><p><strong>Website Usage Information</strong> Our website collects non-personally identifiable information such as navigational data (log files, server logs, click-stream) and information about how our website is used by you (through cookies or web beacons, etc.). We may also collect information such as the URL of the website you previously visited and the time of day that you use our website. Analytics information also keeps track of the pages you visit within our website. You can set your browser to notify you when a cookie is sent, or to refuse or delete cookies altogether, but in such cases many features of our website will not function as designed. Additional information is collected through AdWords Remarketing. AdWords Remarketing is a Remarketing and Behavioral Targeting service provided by Google. It connects the activity of pyrotek.com with the Adwords advertising network and the Doubleclick Cookie. <a href=\"https://www.google.com/settings/ads/onweb#display_optout\">You can opt out of the cookie tracking here.</a></p><p><strong>International Users</strong> As an international company, Pyrotek, Inc. abides by Safe Harbor and Asia-Pacific Economic Cooperation (APEC) Frameworks to ensure consumer privacy and protection. As a part of the Safe Harbor Program, users from the European Union and Switzerland are provided personal data protection as specified by the European Commission. It is our priority to protect the flow of personal information across borders, so that our international users can use our website securely.</p><p>Pyrotek, Inc. stores any collected information within the United States; however, any information collected by Google is stored in accordance with Google’s <a href=\"http://cp.mcafee.com/d/1jWVIq40Ue6zqb3XbZS6bICXCQrCzBxNxAQszDzqdPhOMUMNtdMSyzss-MUqenQPqdPhOMUqehP1EVvdDS5fz2hk54WPFfoPVsSjHeAZzfBPq9EV744ZsvW_9EzCkmkuLsKCPtzC6nxOrbDbnhIyyGzt_BgY-F6lK1FJ4SMrLObPwWWarzPNKVIDeqR4IMFN6Ji9_YLyRjVmBZcmz8PJyS6Q9r3RgklfrwxcDmyLNVsS-CCqenzobZ8Qg1sc0Ao18w2Miq80j7okfSsGMd44v5C_FcSOCrKWLe-MNS\">Privacy Policy</a>. Learn more about the <a href=\"http://cp.mcafee.com/d/k-Kr6hESyM-O_txyX9KVJ6VEVosopd78VUSzsQsIeccnjsdEET7fIe6zBZcSzsQsIe6zAsMqenPpZxjUMAl1heIWjSc-ndAWPFfoPVsSyqehN1fn7-LOq8VB5B7HTbFIToVxBUsCOVORQr8EGETvVkffGhBrwqrjdI6XYyYUeKyCUYYrKr01u7HlzfydjekRTOuN8lzxJ2mMZk55jSU8j9REHYundLFFCzBUS2_id40n30960i80I4Cy04NS53ZDaI3h17NpLWjdIFCOVYl9Fo1K9fS\">Safe Harbor Frameworks</a>. </p><h2>How We Use Your Information</h2><p><strong>Personal Information</strong> We use the personal information that you submit to help enhance and personalize your use of our website. This information also allows us to provide you with relevant information, content, and advertising (on our website, in newsletters, via e-mail, etc.).</p><p>When you respond to an offer of information or a service on our website (for example, by completing an online form), we may use that information to connect you to a specific provider or with a trusted partner who will provide the information or service that you requested.</p><p>We may also use your personal information to respond to your inquiries, send you service e-mails or follow-up with a phone call with important information regarding our website and related services, and to send you newsletters and offers.</p><p><strong>Non-Personal Information</strong> We use anonymous and aggregated data to create statistics and reports for various business purposes. We may aggregate anonymous data and share it with our advertisers or partners in order to offer you potentially desirable content, products, and services.</p><p>The website usage information we collect is used to monitor and improve the operation, technical functions, and quality of our website and services. This data is also used to deliver customized content and advertising to you when your online behavior indicates that you are interested in a particular subject area.</p><p><strong>Disclosure of Data</strong> We do not disclose your personal information to third parties except under certain circumstances. Set forth below are various circumstances under which we may disclose your personal information:</p><ul><li>Certain employees of ours and independent contractors we work with have access to your personally identifiable information for the sole purpose of helping us run our business. These employees and contractors have confidentiality and security obligations.</li>\n<li>We may disclose your information to third parties who provide services, such as (but not limited to): contact information verification, payment processing, customer service, website hosting, and email delivery services.</li>\n<li>We may disclose your information to another business entity should we plan to merge with or be acquired by that business entity; or to any organization involved in a merger, transfer, or sale of our assets or business.</li>\n<li>We may also disclose your personally identifiable information to respond to law enforcement requests, court orders, or other legal processes; or if we believe that such disclosure is necessary to investigate, prevent, or respond to illegal activities, fraud, physical threats to you, others, or to yourself; or as otherwise required by any applicable law or regulation.</li>\n</ul><p>Before we disclose your personally identifiable information for other reasons, we will first obtain your consent, via e-mail, click-through, an online opportunity to enter your preference, or some other manner.</p><p>In the event that we disclose your personally identifiable information in accordance with this section (\"Disclosure of Data\"), we will require third parties to take appropriate measures to protect and maintain the privacy and confidentiality of your personally identifiable information.</p><p><strong>Prohibited Disclosures</strong> Except as set forth above, we will not disclose your personally identifiable information to any third party without your explicit consent. In addition, we will not sell, rent, or otherwise disclose our e-mail list or address list except as explicitly set forth in this Statement.</p><h2>Control of Your Personal Information</h2><p>Our customers may choose whether to provide personally identifiable information at the time of collection. In addition, customers may stop the delivery of future e-mail communications by unsubscribing at any time. For instance, each e-mail you receive (aside from \"service e-mails\") contains instructions explaining how to stop receiving such e-mails.</p><p>If your personally identifiable information (such as zip code, phone, or e-mail or postal address) changes, or if you no longer desire our service, we provide a way for you to correct, update, or delete/deactivate your personally identifiable information.</p><h2>Protection of Information—Security</h2><p>We are committed to the protection of your personal information. We use a variety of security technologies and procedures to help protect your personal information from unauthorized access, use, or disclosure.</p><p>You should keep in mind that no Internet communication is ever completely secure or error-free.</p><h2>Changes to This Statement</h2><p>We may periodically update this Statement to reflect changes in our services and policies. When we post changes to this Statement, we will revise the \"last updated\" date at the top of this Statement. If there are material changes to the Statement or in how we will use your personal information, we will notify you either by posting a prominent notice prior to implementing the change or by sending you a direct notification. We encourage you to periodically review this Statement to be informed of how we are protecting your information.</p><h2>Contact Information</h2><p>If you have questions or complaints regarding this Statement, you should contact us at</p><p>1400 Tower<br> 1400 West Riverside Ave<br> Spokane, WA 99201<br> United States</p><p>+1 (509) 555-1234</p>',NULL,NULL,0,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(98,15,10,1,1,1,'Page','2016-10-24 16:38:18','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,'<p>Last update: October 24, 2016</p><p>Your privacy is important to us. This privacy policy discusses how and why we collect information from you and what we do with it. This Privacy Policy applies to our website, 1400tower.com.</p><h2>Collection of Information</h2><p><strong>Personal Information</strong> You may submit to us personal information that identifies you as an individual when you choose to interact with us on this website. Personal information that you may submit includes your name, e-mail address, postal address and telephone number. In some cases, you may also submit demographic information such as your age, gender, zip code, level of education, household income, and interests. If we combine demographic information with your personal information, we will treat it as personal information as set forth in this Privacy Statement. In some cases, you may provide additional information including when you choose to personalize your use of our website for medical conditions of interest, when you ask a question of our experts, or when you contact our customer support group.</p><p><strong>Personal Information Provided When Requesting Information</strong> On this website you will find web forms where you are requested to submit personal information in order to be contacted by our Sales and/or Marketing Department. When you submit your personal information via such forms, we will make our best effort to protect your personal information in accordance with our privacy and information security policies.</p><p><strong>Children\'s Personal Information</strong> We do not knowingly collect personally identifiable information from users under the age of 13. If we find out that we have such personal information, we will take reasonable steps to delete it.</p><p><strong>Website Usage Information</strong> Our website collects non-personally identifiable information such as navigational data (log files, server logs, click-stream) and information about how our website is used by you (through cookies or web beacons, etc.). We may also collect information such as the URL of the website you previously visited and the time of day that you use our website. Analytics information also keeps track of the pages you visit within our website. You can set your browser to notify you when a cookie is sent, or to refuse or delete cookies altogether, but in such cases many features of our website will not function as designed. Additional information is collected through AdWords Remarketing. AdWords Remarketing is a Remarketing and Behavioral Targeting service provided by Google. It connects the activity of 1400tower.com with the Adwords advertising network and the Doubleclick Cookie. <a href=\"https://www.google.com/settings/ads/onweb#display_optout\">You can opt out of the cookie tracking here.</a></p><p><strong>International Users</strong> As an international company, Pyrotek, Inc. abides by Safe Harbor and Asia-Pacific Economic Cooperation (APEC) Frameworks to ensure consumer privacy and protection. As a part of the Safe Harbor Program, users from the European Union and Switzerland are provided personal data protection as specified by the European Commission. It is our priority to protect the flow of personal information across borders, so that our international users can use our website securely.</p><p>Pyrotek, Inc. stores any collected information within the United States; however, any information collected by Google is stored in accordance with Google’s <a href=\"http://cp.mcafee.com/d/1jWVIq40Ue6zqb3XbZS6bICXCQrCzBxNxAQszDzqdPhOMUMNtdMSyzss-MUqenQPqdPhOMUqehP1EVvdDS5fz2hk54WPFfoPVsSjHeAZzfBPq9EV744ZsvW_9EzCkmkuLsKCPtzC6nxOrbDbnhIyyGzt_BgY-F6lK1FJ4SMrLObPwWWarzPNKVIDeqR4IMFN6Ji9_YLyRjVmBZcmz8PJyS6Q9r3RgklfrwxcDmyLNVsS-CCqenzobZ8Qg1sc0Ao18w2Miq80j7okfSsGMd44v5C_FcSOCrKWLe-MNS\">Privacy Policy</a>. Learn more about the <a href=\"http://cp.mcafee.com/d/k-Kr6hESyM-O_txyX9KVJ6VEVosopd78VUSzsQsIeccnjsdEET7fIe6zBZcSzsQsIe6zAsMqenPpZxjUMAl1heIWjSc-ndAWPFfoPVsSyqehN1fn7-LOq8VB5B7HTbFIToVxBUsCOVORQr8EGETvVkffGhBrwqrjdI6XYyYUeKyCUYYrKr01u7HlzfydjekRTOuN8lzxJ2mMZk55jSU8j9REHYundLFFCzBUS2_id40n30960i80I4Cy04NS53ZDaI3h17NpLWjdIFCOVYl9Fo1K9fS\">Safe Harbor Frameworks</a>. </p><h2>How We Use Your Information</h2><p><strong>Personal Information</strong> We use the personal information that you submit to help enhance and personalize your use of our website. This information also allows us to provide you with relevant information, content, and advertising (on our website, in newsletters, via e-mail, etc.).</p><p>When you respond to an offer of information or a service on our website (for example, by completing an online form), we may use that information to connect you to a specific provider or with a trusted partner who will provide the information or service that you requested.</p><p>We may also use your personal information to respond to your inquiries, send you service e-mails or follow-up with a phone call with important information regarding our website and related services, and to send you newsletters and offers.</p><p><strong>Non-Personal Information</strong> We use anonymous and aggregated data to create statistics and reports for various business purposes. We may aggregate anonymous data and share it with our advertisers or partners in order to offer you potentially desirable content, products, and services.</p><p>The website usage information we collect is used to monitor and improve the operation, technical functions, and quality of our website and services. This data is also used to deliver customized content and advertising to you when your online behavior indicates that you are interested in a particular subject area.</p><p><strong>Disclosure of Data</strong> We do not disclose your personal information to third parties except under certain circumstances. Set forth below are various circumstances under which we may disclose your personal information:</p><ul><li>Certain employees of ours and independent contractors we work with have access to your personally identifiable information for the sole purpose of helping us run our business. These employees and contractors have confidentiality and security obligations.</li>\n<li>We may disclose your information to third parties who provide services, such as (but not limited to): contact information verification, payment processing, customer service, website hosting, and email delivery services.</li>\n<li>We may disclose your information to another business entity should we plan to merge with or be acquired by that business entity; or to any organization involved in a merger, transfer, or sale of our assets or business.</li>\n<li>We may also disclose your personally identifiable information to respond to law enforcement requests, court orders, or other legal processes; or if we believe that such disclosure is necessary to investigate, prevent, or respond to illegal activities, fraud, physical threats to you, others, or to yourself; or as otherwise required by any applicable law or regulation.</li>\n</ul><p>Before we disclose your personally identifiable information for other reasons, we will first obtain your consent, via e-mail, click-through, an online opportunity to enter your preference, or some other manner.</p><p>In the event that we disclose your personally identifiable information in accordance with this section (\"Disclosure of Data\"), we will require third parties to take appropriate measures to protect and maintain the privacy and confidentiality of your personally identifiable information.</p><p><strong>Prohibited Disclosures</strong> Except as set forth above, we will not disclose your personally identifiable information to any third party without your explicit consent. In addition, we will not sell, rent, or otherwise disclose our e-mail list or address list except as explicitly set forth in this Statement.</p><h2>Control of Your Personal Information</h2><p>Our customers may choose whether to provide personally identifiable information at the time of collection. In addition, customers may stop the delivery of future e-mail communications by unsubscribing at any time. For instance, each e-mail you receive (aside from \"service e-mails\") contains instructions explaining how to stop receiving such e-mails.</p><p>If your personally identifiable information (such as zip code, phone, or e-mail or postal address) changes, or if you no longer desire our service, we provide a way for you to correct, update, or delete/deactivate your personally identifiable information.</p><h2>Protection of Information—Security</h2><p>We are committed to the protection of your personal information. We use a variety of security technologies and procedures to help protect your personal information from unauthorized access, use, or disclosure.</p><p>You should keep in mind that no Internet communication is ever completely secure or error-free.</p><h2>Changes to This Statement</h2><p>We may periodically update this Statement to reflect changes in our services and policies. When we post changes to this Statement, we will revise the \"last updated\" date at the top of this Statement. If there are material changes to the Statement or in how we will use your personal information, we will notify you either by posting a prominent notice prior to implementing the change or by sending you a direct notification. We encourage you to periodically review this Statement to be informed of how we are protecting your information.</p><h2>Contact Information</h2><p>If you have questions or complaints regarding this Statement, you should contact us at</p><p>1400 Tower<br> 1400 West Riverside Ave<br> Spokane, WA 99201<br> United States</p><p>+1 (509) 555-1234</p>',NULL,NULL,0,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(99,15,11,1,1,1,'Page','2016-10-24 16:38:57','2016-08-25 16:36:05','privacy-policy','Privacy Policy',NULL,'<p>Last update: October 24, 2016</p><p>Your privacy is important to us. This privacy policy discusses how and why we collect information from you and what we do with it. This Privacy Policy applies to our website, 1400tower.com.</p><h2>Collection of Information</h2><p><strong>Personal Information</strong> You may submit to us personal information that identifies you as an individual when you choose to interact with us on this website. Personal information that you may submit includes your name, e-mail address, postal address and telephone number. In some cases, you may also submit demographic information such as your age, gender, zip code, level of education, household income, and interests. If we combine demographic information with your personal information, we will treat it as personal information as set forth in this Privacy Statement. In some cases, you may provide additional information including when you choose to personalize your use of our website for medical conditions of interest, when you ask a question of our experts, or when you contact our customer support group.</p><p><strong>Personal Information Provided When Requesting Information</strong> On this website you will find web forms where you are requested to submit personal information in order to be contacted by our Sales and/or Marketing Department. When you submit your personal information via such forms, we will make our best effort to protect your personal information in accordance with our privacy and information security policies.</p><p><strong>Children\'s Personal Information</strong> We do not knowingly collect personally identifiable information from users under the age of 13. If we find out that we have such personal information, we will take reasonable steps to delete it.</p><p><strong>Website Usage Information</strong> Our website collects non-personally identifiable information such as navigational data (log files, server logs, click-stream) and information about how our website is used by you (through cookies or web beacons, etc.). We may also collect information such as the URL of the website you previously visited and the time of day that you use our website. Analytics information also keeps track of the pages you visit within our website. You can set your browser to notify you when a cookie is sent, or to refuse or delete cookies altogether, but in such cases many features of our website will not function as designed. Additional information is collected through AdWords Remarketing. AdWords Remarketing is a Remarketing and Behavioral Targeting service provided by Google. It connects the activity of 1400tower.com with the Adwords advertising network and the Doubleclick Cookie. <a href=\"https://www.google.com/settings/ads/onweb#display_optout\">You can opt out of the cookie tracking here.</a></p><h2>How We Use Your Information</h2><p><strong>Personal Information</strong> We use the personal information that you submit to help enhance and personalize your use of our website. This information also allows us to provide you with relevant information, content, and advertising (on our website, in newsletters, via e-mail, etc.).</p><p>When you respond to an offer of information or a service on our website (for example, by completing an online form), we may use that information to connect you to a specific provider or with a trusted partner who will provide the information or service that you requested.</p><p>We may also use your personal information to respond to your inquiries, send you service e-mails or follow-up with a phone call with important information regarding our website and related services, and to send you newsletters and offers.</p><p><strong>Non-Personal Information</strong> We use anonymous and aggregated data to create statistics and reports for various business purposes. We may aggregate anonymous data and share it with our advertisers or partners in order to offer you potentially desirable content, products, and services.</p><p>The website usage information we collect is used to monitor and improve the operation, technical functions, and quality of our website and services. This data is also used to deliver customized content and advertising to you when your online behavior indicates that you are interested in a particular subject area.</p><p><strong>Disclosure of Data</strong> We do not disclose your personal information to third parties except under certain circumstances. Set forth below are various circumstances under which we may disclose your personal information:</p><ul><li>Certain employees of ours and independent contractors we work with have access to your personally identifiable information for the sole purpose of helping us run our business. These employees and contractors have confidentiality and security obligations.</li>\n<li>We may disclose your information to third parties who provide services, such as (but not limited to): contact information verification, payment processing, customer service, website hosting, and email delivery services.</li>\n<li>We may disclose your information to another business entity should we plan to merge with or be acquired by that business entity; or to any organization involved in a merger, transfer, or sale of our assets or business.</li>\n<li>We may also disclose your personally identifiable information to respond to law enforcement requests, court orders, or other legal processes; or if we believe that such disclosure is necessary to investigate, prevent, or respond to illegal activities, fraud, physical threats to you, others, or to yourself; or as otherwise required by any applicable law or regulation.</li>\n</ul><p>Before we disclose your personally identifiable information for other reasons, we will first obtain your consent, via e-mail, click-through, an online opportunity to enter your preference, or some other manner.</p><p>In the event that we disclose your personally identifiable information in accordance with this section (\"Disclosure of Data\"), we will require third parties to take appropriate measures to protect and maintain the privacy and confidentiality of your personally identifiable information.</p><p><strong>Prohibited Disclosures</strong> Except as set forth above, we will not disclose your personally identifiable information to any third party without your explicit consent. In addition, we will not sell, rent, or otherwise disclose our e-mail list or address list except as explicitly set forth in this Statement.</p><h2>Control of Your Personal Information</h2><p>Our customers may choose whether to provide personally identifiable information at the time of collection. In addition, customers may stop the delivery of future e-mail communications by unsubscribing at any time. For instance, each e-mail you receive (aside from \"service e-mails\") contains instructions explaining how to stop receiving such e-mails.</p><p>If your personally identifiable information (such as zip code, phone, or e-mail or postal address) changes, or if you no longer desire our service, we provide a way for you to correct, update, or delete/deactivate your personally identifiable information.</p><h2>Protection of Information—Security</h2><p>We are committed to the protection of your personal information. We use a variety of security technologies and procedures to help protect your personal information from unauthorized access, use, or disclosure.</p><p>You should keep in mind that no Internet communication is ever completely secure or error-free.</p><h2>Changes to This Statement</h2><p>We may periodically update this Statement to reflect changes in our services and policies. When we post changes to this Statement, we will revise the \"last updated\" date at the top of this Statement. If there are material changes to the Statement or in how we will use your personal information, we will notify you either by posting a prominent notice prior to implementing the change or by sending you a direct notification. We encourage you to periodically review this Statement to be informed of how we are protecting your information.</p><h2>Contact Information</h2><p>If you have questions or complaints regarding this Statement, you should contact us at</p><p>1400 Tower<br> 1400 West Riverside Ave<br> Spokane, WA 99201<br> United States</p><p>+1 (509) 555-1234</p>',NULL,NULL,0,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(100,3,3,1,1,1,'Page','2016-10-24 16:45:55','2016-08-25 15:13:19','contact-us','Contact Us',NULL,'<p>For more information about 1400 Tower please contact us at:</p><p><a href=\"mailto:info@1400tower.com\">info@1400tower.com</a>  or (Phone number?) </p>',NULL,NULL,1,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(101,1,12,1,1,1,'HomePage','2016-10-24 16:53:48','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(102,1,13,1,1,1,'HomePage','2016-10-24 16:54:16','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(103,2,8,1,1,1,'BioHolderPage','2016-10-24 16:54:50','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants or enjoying the city’s first class entertainment venues.  1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.”   Amenities will also include secure covered parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all unites. </p><h2>1400 Principals</h2><p class=\"highlight\">1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(104,8,10,1,1,1,'BioPage','2016-10-25 09:29:53','2016-08-25 16:28:14','shelley-mcdowell','SHELLEY McDOWELL',NULL,'<p>Shelley McDowell is a licensed Real Estate Managing Broker, developer and former investment advisor.   A life-long Spokane resident, Shelley holds a Bachelor of Science in Business Administration from U. of the State of NY, Albany and is currently the Branch Manager for Century 21 Beutler &amp; Associates Spokane office.  Shelley spent 10 years as an investment advisor before deciding to help her husband Mick develop almost 30 downtown Spokane projects and manage 250 apartment units.  Shelley continues to help Mick own and operate downtown’s Banner Bank building. </p><p>Shelley’s also very community minded.  She’s a YMCA board member, past board member and Chair of the Spokane Club, Past President and board member of EWI of Spokane and currently sits on the Riverbank Board of Directors.</p><p>Summers find Shelley enjoying mountain biking, boating, swimming and hiking.   She spends the cooler weather in spinning classes, sitting by cozy fires and sipping fine wine. </p>',NULL,NULL,0,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(105,2,9,1,1,1,'BioHolderPage','2016-10-25 09:35:22','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants or enjoying the city’s first class entertainment venues. 1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.” Amenities will also include secure covered parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all unites. </p><h2>1400 Principals</h2><p class=\"highlight\">1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(106,1,14,1,1,1,'HomePage','2016-10-27 15:22:06','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(107,1,15,1,1,1,'HomePage','2016-10-27 15:30:32','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know that Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(108,2,10,1,2,2,'BioHolderPage','2016-11-01 16:31:37','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants and enjoying the city’s first class entertainment venues. 1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.” Amenities will also include secure, climate controlled parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all units. </p><h2>1400 Principals</h2><p class=\"highlight\">1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(109,7,10,1,2,2,'BioPage','2016-11-01 16:33:43','2016-08-25 16:27:59','mick-mcdowell','MICK McDOWELL',NULL,'<p>Mick McDowell is a highly experienced and well qualified developer, builder and community leader.  Over the past 40 years, Mick has purchased and restored almost 30 buildings in downtown Spokane all of which continue to successfully operate today.  His landmark project is the five story Banner Bank building near the Division Street gateway in downtown. In addition, Mick sits on the Spokane Public Facility District Board of Directors and chairs the Project Committee which oversaw the recently completed multi-million dollar Spokane Convention Center expansion effort.  He also served as chair of the Downtown Spokane Partnership.  Mick began his developer’s career while working as a full-time firefighter with the Spokane Fire Department and served 20 years with distinction before retiring to concentrate on his other interests.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(110,8,11,1,2,2,'BioPage','2016-11-01 16:39:16','2016-08-25 16:28:14','shelley-mcdowell','SHELLEY McDOWELL',NULL,'<p>Shelley McDowell is a licensed Real Estate Managing Broker, developer and former investment advisor.   A life-long Spokane resident, Shelley holds a Bachelor of Science in Business Administration from the University of the State of NY, Albany and is currently the Branch Manager for Century 21 Beutler &amp; Associates Spokane office.  Shelley spent 10 years as an investment advisor before partnering with her husband Mick to develop almost 30 downtown Spokane projects and manage over 800 apartment units.  Shelley continues to help Mick own and operate downtown’s Banner Bank building. </p><p>Shelley’s also very community minded.  She’s a past YMCA board member, past board member and Chair of the Spokane Club, Past President and board member of EWI of Spokane and currently sits on the Riverbank Board of Directors as a founding member.</p><p>Summers find Shelley enjoying mountain biking, boating, swimming and hiking.   She spends the cooler weather in spinning classes, sitting by cozy fires and sipping fine wines. </p>',NULL,NULL,0,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(111,9,9,1,2,2,'BioPage','2016-11-01 16:42:26','2016-08-25 16:28:27','anton-c-delateur','ANTON C. DeLATEUR',NULL,'<p>Anton DeLateur is a Spokane businessman and Financial Advisor and a long-time supporter of various business, educational and charitable interests.  He brings over 36 years of experience in finance and organization to our enterprise.  Anton earned a BA in Philosophy and Classical languages from St. Thomas in Seattle in 1967 and a Licentiate in Philosophy from Gonzaga University.  He also taught Classical languages and music at Gonzaga Prep and JFK Memorial High School in Seattle from 1969 to 1979 before joining the financial world.  He has served on the board of Morningstar Boys Ranch, is advisor to St. Joseph’s Family Center, and has been an ardent supporter of local music and marching band organizations. </p>',NULL,NULL,0,1,3,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(112,10,9,1,2,2,'BioPage','2016-11-01 16:44:27','2016-08-25 16:28:46','donald-howell','DONALD HOWELL',NULL,'<p>Don Howell has been involved in a broad spectrum of highly varied real estate and business related activities spanning an almost 40 career of corporate and personal business enterprises.  Don’s successful efforts include a 31-year management position career with a national title and escrow company, numerous private property investment opportunities including acquisition and operating a private equity financing company, a manufacturing company, commercial property acquisition and renovation, and residential home construction enterprise. </p>',NULL,NULL,0,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(113,10,10,1,2,2,'BioPage','2016-11-01 16:45:29','2016-08-25 16:28:46','donald-howell','DONALD HOWELL',NULL,'<p>Don Howell has been involved in a broad spectrum of highly varied real estate and business related activities spanning an almost 40 career of corporate and personal business enterprises.  Don’s successful efforts include a 31-year management position career with a national title and escrow company, numerous private property investment opportunities including acquisition and operating a private equity financing company, a manufacturing company, commercial property acquisition and renovation, and residential home construction enterprise.  Don is an active member of Spokane Rotary 21 and current chair of the Priest Lake Memory Garden project.</p>',NULL,NULL,0,1,4,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(114,1,16,1,2,2,'HomePage','2016-11-01 16:53:10','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(115,1,17,1,1,1,'HomePage','2016-11-09 12:04:23','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(116,1,18,1,1,1,'HomePage','2016-11-09 12:05:32','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(117,1,19,1,2,2,'HomePage','2016-11-10 09:29:19','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(118,3,4,1,2,2,'Page','2016-11-10 09:32:40','2016-08-25 15:13:19','contact-us','Contact Us',NULL,'<p>For more information about 1400 Tower please contact us at:</p><p><a href=\"mailto:info@1400tower.com\">info@1400tower.com</a> or call 509-991-1000</p>',NULL,NULL,1,1,5,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(119,2,11,0,2,0,'BioHolderPage','2016-11-10 09:52:06','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants and enjoying the city’s first class entertainment venues. 1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.” Amenities will also include secure, climate controlled parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all units. </p><h2>1400 Principals</h2><p class=\"highlight\">1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.<a name=\"Anchor\"></a></p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(120,2,12,1,2,2,'BioHolderPage','2016-11-10 09:53:06','2016-08-25 15:13:19','about-us','About 1400 Tower',NULL,'<p>1400 Tower’s West Riverside Avenue location is superb for that short walk to work, the stunning views overlooking the Spokane River Gorge, Downtown and the Idaho mountains, dining in your favorite restaurants and enjoying the city’s first class entertainment venues. 1400 Tower’s 55 high-end and top-quality condos will have interior designs and finishes that promise to be “best-in-class.” Amenities will also include secure, climate controlled parking, a large outdoor private green space, state-of-the-art heating and cooling and balconies for all units. </p><h2>1400 Principals</h2><p class=\"highlight\">1400 Tower’s principals have decades of experience in the development, construction and real estate industry; our local roots also run deep.</p>',NULL,NULL,1,1,2,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(121,17,3,0,2,0,'BioPage','2016-11-10 10:18:03','2016-11-10 10:18:03','new-bio-page','New Bio Page',NULL,NULL,NULL,NULL,1,1,7,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(122,17,4,0,2,0,'BioPage','2016-11-10 10:21:27','2016-11-10 10:18:03','new-bio-page','New Bio Page',NULL,NULL,NULL,NULL,1,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(123,17,5,0,2,0,'BioPage','2016-11-10 10:21:35','2016-11-10 10:18:03','new-bio-page','New Bio Page',NULL,NULL,NULL,NULL,1,1,6,0,0,NULL,'Inherit','Inherit',NULL,NULL,15),(124,17,6,0,2,0,'BioPage','2016-11-10 10:21:35','2016-11-10 10:18:03','new-bio-page','New Bio Page',NULL,NULL,NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,15),(125,17,7,0,2,0,'BioPage','2016-11-10 10:22:05','2016-11-10 10:18:03','new-bio-page','New Bio Page',NULL,NULL,NULL,NULL,1,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(126,17,8,0,2,0,'BioPage','2016-11-10 10:22:05','2016-11-10 10:18:03','new-bio-page','New Bio Page',NULL,NULL,NULL,NULL,1,1,7,0,0,NULL,'Inherit','Inherit',NULL,NULL,2),(127,1,20,1,1,1,'HomePage','2016-11-15 14:49:57','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(128,1,21,1,1,1,'HomePage','2016-11-15 14:55:56','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(129,1,22,1,1,1,'HomePage','2016-12-02 11:48:39','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(130,1,23,1,1,1,'HomePage','2016-12-02 11:49:39','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0),(131,1,24,1,1,1,'HomePage','2016-12-05 16:52:53','2016-08-25 15:13:19','home','Home',NULL,'<h2>Convenient Luxury Living</h2><p>We all know Downtown Spokane has a unique energy, history and elegance---those rare qualities are about to see an addition that will make things even better. 1400 Tower, the city’s first luxury condominium high-rise, is set to help you enjoy the convenience, fun and lifestyle that is Downtown. </p><p>Be a part of 1400 Tower and enjoy life at what will be the region’s most luxurious address.</p>',NULL,NULL,0,1,1,0,0,NULL,'Inherit','Inherit',NULL,NULL,0);
/*!40000 ALTER TABLE `SiteTree_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `VirtualPage`
--

DROP TABLE IF EXISTS `VirtualPage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `VirtualPage` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `VersionID` int(11) NOT NULL DEFAULT '0',
  `CopyContentFromID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `CopyContentFromID` (`CopyContentFromID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `VirtualPage`
--

LOCK TABLES `VirtualPage` WRITE;
/*!40000 ALTER TABLE `VirtualPage` DISABLE KEYS */;
/*!40000 ALTER TABLE `VirtualPage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `VirtualPage_Live`
--

DROP TABLE IF EXISTS `VirtualPage_Live`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `VirtualPage_Live` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `VersionID` int(11) NOT NULL DEFAULT '0',
  `CopyContentFromID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `CopyContentFromID` (`CopyContentFromID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `VirtualPage_Live`
--

LOCK TABLES `VirtualPage_Live` WRITE;
/*!40000 ALTER TABLE `VirtualPage_Live` DISABLE KEYS */;
/*!40000 ALTER TABLE `VirtualPage_Live` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `VirtualPage_versions`
--

DROP TABLE IF EXISTS `VirtualPage_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `VirtualPage_versions` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `RecordID` int(11) NOT NULL DEFAULT '0',
  `Version` int(11) NOT NULL DEFAULT '0',
  `VersionID` int(11) NOT NULL DEFAULT '0',
  `CopyContentFromID` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `RecordID_Version` (`RecordID`,`Version`),
  KEY `RecordID` (`RecordID`),
  KEY `Version` (`Version`),
  KEY `CopyContentFromID` (`CopyContentFromID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `VirtualPage_versions`
--

LOCK TABLES `VirtualPage_versions` WRITE;
/*!40000 ALTER TABLE `VirtualPage_versions` DISABLE KEYS */;
/*!40000 ALTER TABLE `VirtualPage_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database '1400tower'
--

--
-- Dumping routines for database '1400tower'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-04-07 15:51:11
